<?php 
include_once 'db.php';

// Initialize an empty array to store the reports data
$reportsData = [];

// Query to fetch the reports
$sql = 'SELECT * FROM reports ORDER BY id DESC';  
$result = $connection->query($sql);

if ($result) {
    // Fetch all rows
    foreach ($result as $row) {
        $reportName = "";

        // Map the report IDs to report names
        switch ($row['report']) {
            case 1:
                $reportName = "Order Report";
                break;
            case 2:
                $reportName = "Invoice Report";
                break;
            case 3:
                $reportName = "Customer Report";
                break;
            case 4:
                $reportName = "Order Item Report";
                break;
            case 5:
                $reportName = "Payment Report";
                break;
            case 6:
                $reportName = "Product Inventory Report";
                break;
            case 7:
                $reportName = "GST Sales Report";
                break;
            case 8:
                $reportName = "Daily Sale Summary";
                break;
            case 9:
                $reportName = "Abandoned Cart Report";
                break;
            case 10:
                $reportName = "Order and Order Item Report";
                break;
            case 11:
                $reportName = "Whatsapp Bot Report";
                break;
            default:
                $reportName = "Unknown Report";
                break;
        }

        // Prepare the report data
        $reportsData[] = [
            'report_name' => $reportName,
            'duration' => $row['durationval'],
            'date_range' => $row['rangedate'],
            'download_link' => $row['excelname'],
            'generating' => false, // Initially, set the generating status to false
        ];
    }

    // Send the response as JSON
    echo json_encode([
        'status' => 'success',
        'data' => $reportsData,
    ]);
} else {
    // If the query fails, return an error message
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch reports.',
    ]);
}
?>
