<?php
include_once 'db.php';

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (isset($_POST['id'])) {
    $id = mysqli_real_escape_string($connection, $_POST['id']);

    // Start transaction
    mysqli_begin_transaction($connection);

    try {
        // Fetch data from purchase table
        $selectPurchase = "SELECT * FROM purchase WHERE id = '$id'";
        $result = mysqli_query($connection, $selectPurchase);
        if (!$result) {
            throw new Exception('Failed to fetch purchase data: ' . mysqli_error($connection));
        }

        $purchaseData = mysqli_fetch_assoc($result);
        if (!$purchaseData) {
            throw new Exception('No data found for ID: ' . $id);
        }

        // Insert data into purchasedelete table
        $insertPurchaseDelete = "INSERT INTO purchasedelete (id, purchaseno, amount, balance, entrydate, vendorid, purcahsedate, subtotal, totalsaving, tax, grandtotal, forsalecheck, shipping, delivery, discountpercentage, discountvalue, total_tax, duedate, delete_status, status, creatorid, editorid, roundoff, totalsavings, totaltax, due) VALUES ('{$purchaseData['id']}', '{$purchaseData['purchaseno']}', '{$purchaseData['amount']}', '{$purchaseData['balance']}', '{$purchaseData['entrydate']}', '{$purchaseData['vendorid']}', '{$purchaseData['purcahsedate']}', '{$purchaseData['subtotal']}', '{$purchaseData['totalsaving']}', '{$purchaseData['tax']}', '{$purchaseData['grandtotal']}', '{$purchaseData['forsalecheck']}', '{$purchaseData['shipping']}', '{$purchaseData['delivery']}', '{$purchaseData['discountpercentage']}', '{$purchaseData['discountvalue']}', '{$purchaseData['total_tax']}', '{$purchaseData['duedate']}', '{$purchaseData['delete_status']}', '{$purchaseData['status']}', '{$purchaseData['creatorid']}', '{$purchaseData['editorid']}', '{$purchaseData['roundoff']}', '{$purchaseData['totalsavings']}', '{$purchaseData['totaltax']}', '{$purchaseData['due']}')";
        if (!mysqli_query($connection, $insertPurchaseDelete)) {
            throw new Exception('Failed to insert into purchasedelete table: ' . mysqli_error($connection));
        }

        // Fetch data from purchasedata table
        $selectPurchaseData = "SELECT * FROM purchasedata WHERE purchaseid = '$id'";
        $result = mysqli_query($connection, $selectPurchaseData);
        if (!$result) {
            throw new Exception('Failed to fetch purchasedata: ' . mysqli_error($connection));
        }

        while ($purchaseDataItem = mysqli_fetch_assoc($result)) {
            // Insert data into purchasedatadelete table
            $insertPurchaseDataDelete = "INSERT INTO purchasedatadelete (id, purchaseid, productid, qty, mrp, saleprice, price, discountpercentage, pricetype, discountvalue, discounttpercentage, taxpercentage, taxvalue, amount, delete_stats, creatorid, editorid) VALUES ('{$purchaseDataItem['id']}', '{$purchaseDataItem['purchaseid']}', '{$purchaseDataItem['productid']}', '{$purchaseDataItem['qty']}', '{$purchaseDataItem['mrp']}', '{$purchaseDataItem['saleprice']}', '{$purchaseDataItem['price']}', '{$purchaseDataItem['discountpercentage']}', '{$purchaseDataItem['pricetype']}', '{$purchaseDataItem['discountvalue']}', '{$purchaseDataItem['discounttpercentage']}', '{$purchaseDataItem['taxpercentage']}', '{$purchaseDataItem['taxvalue']}', '{$purchaseDataItem['amount']}', '{$purchaseDataItem['delete_stats']}', '{$purchaseDataItem['creatorid']}', '{$purchaseDataItem['editorid']}')";
            if (!mysqli_query($connection, $insertPurchaseDataDelete)) {
                throw new Exception('Failed to insert into purchasedatadelete table: ' . mysqli_error($connection));
            }
        }

        // Delete from purchase table
        $deletePurchase = "DELETE FROM purchase WHERE id = '$id'";
        if (!mysqli_query($connection, $deletePurchase)) {
            throw new Exception('Failed to delete from purchase table: ' . mysqli_error($connection));
        }

        // Delete from purchasedata table
        $deletePurchaseData = "DELETE FROM purchasedata WHERE purchaseid = '$id'";
        if (!mysqli_query($connection, $deletePurchaseData)) {
            throw new Exception('Failed to delete from purchasedata table: ' . mysqli_error($connection));
        }

        // Commit transaction
        mysqli_commit($connection);

        // Return success response
        echo json_encode(['success' => 'Record deleted successfully.']);
    } catch (Exception $e) {
        // Rollback transaction on error
        mysqli_rollback($connection);

        // Return error response
        echo json_encode(['error' => 'Failed to delete record: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'ID not provided.']);
}

mysqli_close($connection);
?>
