<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once 'db.php';
$invoiceid = $_POST['invoiceid'] ?? ''; 

// Log POST data for debugging
$logFile = 'post_data_log.txt';
file_put_contents($logFile, print_r($_POST, true), FILE_APPEND);
// Ensure all required POST fields are set
$requiredFields = [
    'invoiceid', 'productid', 'mrp', 'qty', 'price', 'discountvalue', 'discountpercentage',
    'taxvalue', 'taxpercentage', 'customerid', 'grandtotals', 'invoicedate',
    'duedate', 'amount', 'shipping', 'roundoff', 'totaltax', 'totalsavings','balance','paymentstatus'
];

foreach ($requiredFields as $field) {
    if (!isset($_POST[$field])) {
        die('Error: Missing required POST data - ' . $field);
    }
}

// Retrieve POST data
$invoiceid = $_POST["invoiceid"];
$productid = $_POST["productid"];
$mrp = $_POST["mrp"];
$qty = $_POST["qty"];
$price = $_POST["price"];
$discountvalue = $_POST["discountvalue"];
$discountpercentage = $_POST["discountpercentage"];
$taxvalue = $_POST["taxvalue"];
$taxpercentage = $_POST["taxpercentage"];
$customerid = $_POST["customerid"];
$grandtotals = $_POST["grandtotals"];
$invoicedate = $_POST["invoicedate"];
$duedate = $_POST["duedate"];
$amount = $_POST["amount"];
$shipping = $_POST["shipping"];
$roundoff = $_POST["roundoff"];
$totaltax = $_POST["totaltax"];
$totalsavings = $_POST["totalsavings"];
$balnce= $_POST["balance"];
$paymentstatus= $_POST["paymentstatus"];

// Debugging lines to check data
file_put_contents($logFile, "\n\nReceived data:\n", FILE_APPEND);
file_put_contents($logFile, "taxpercentage: " . print_r($taxpercentage, true) . "\n", FILE_APPEND);



// Calculate total amounts for new products
for ($count = 0; $count < count($productid); $count++) {
    $amount_clean = mysqli_real_escape_string($connection, $amount[$count]);
}

// Update invoice
$sql = "UPDATE invoice
        SET invoicedate='$invoicedate',
            duedate='$duedate',
            customerid='$customerid',
            grandtotal='$grandtotals',
            shipping='$shipping',
            roundoff='$roundoff',
            totaltax='$totaltax',
            totalsavings='$totalsavings',
            balance='$balnce',
            paymentstatus='$paymentstatus'
        WHERE id='$invoiceid'";
$queryexecute = mysqli_query($connection, $sql);

if (!$queryexecute) {
    die('Error updating invoice: ' . mysqli_error($connection));
}

// Delete existing invoicedata records for the invoice
$sql = "DELETE FROM invoicedata WHERE invoiceid='$invoiceid'";
$queryexecute = mysqli_query($connection, $sql);

if (!$queryexecute) {
    die('Error deleting existing invoicedata: ' . mysqli_error($connection));
}

// Insert new invoicedata records
for ($count = 0; $count < count($productid); $count++) {
    $item_name_clean = mysqli_real_escape_string($connection, $productid[$count]);
    $mrp_clean = mysqli_real_escape_string($connection, $mrp[$count]);
    $qty_clean = mysqli_real_escape_string($connection, $qty[$count]);
    $price_clean = mysqli_real_escape_string($connection, $price[$count]);
    $discountvalue_clean = mysqli_real_escape_string($connection, $discountvalue[$count]);
    $discountpercentage_clean = mysqli_real_escape_string($connection, $discountpercentage[$count]);
    $taxvalue_clean = mysqli_real_escape_string($connection, $taxvalue[$count]);
    $taxpercentage_clean = !empty($taxpercentage[$count]) ? mysqli_real_escape_string($connection, $taxpercentage[$count]) : '0'; // Default to 0 if empty
    $amount_clean = mysqli_real_escape_string($connection, $amount[$count]);

    // Insert new record
    $sql = "INSERT INTO invoicedata (invoiceid, productid, mrp, qty, price, discountvalue, discountpercentage, taxvalue, taxpercentage, amount)
            VALUES ('$invoiceid', '$item_name_clean', '$mrp_clean', '$qty_clean', '$price_clean', '$discountvalue_clean', '$discountpercentage_clean', '$taxvalue_clean', '$taxpercentage_clean', '$amount_clean')";
    
    $queryexecute = mysqli_query($connection, $sql);

    if (!$queryexecute) {
        die('Error inserting new invoicedata: ' . mysqli_error($connection));
    }
}

// Fetch the total amount paid for the invoice
$sql = "SELECT SUM(amount) AS totalcustomerpayment 
        FROM customerpayment 
        WHERE invoiceid='$invoiceid'";
$result = mysqli_query($connection, $sql);
$customerpaymentrow = mysqli_fetch_array($result);
$totalcustomerpayment = $customerpaymentrow['totalcustomerpayment'];

// Calculate due amount
$dueAmount = $newGrandTotal - $totalcustomerpayment;

// Determine payment status
if ($dueAmount == 0) {
    $paymentstatus = 1; // Fully paid
} elseif ($dueAmount < $newGrandTotal) {
    $paymentstatus = 2; // Partially paid
} else {
    $paymentstatus = 0; // Unpaid
}

// Update payment status in invoice
$sql = "UPDATE invoice
        SET paymentstatus='$paymentstatus'
        WHERE id='$invoiceid'";
$queryexecute = mysqli_query($connection, $sql);

if (!$queryexecute) {
    die('Error updating payment status: ' . mysqli_error($connection));
}

// Return success response
echo 'Invoice updated successfully.';

// Close database connection
mysqli_close($connection);
?>
