<?php
include_once 'db.php';

// Debugging: Log incoming POST data
file_put_contents('debug_log.txt', "POST Data:\n" . print_r($_POST, true) . "\n", FILE_APPEND);

// Capture POST data
$productid = $_POST["productid"] ?? [];
$invoiceid = $_POST["invoiceid"] ?? null;
$mrp = $_POST["mrp"] ?? [];
$qty = $_POST["qty"] ?? [];
$price = $_POST["price"] ?? [];
$discountvalue = $_POST["discountvalue"] ?? [];
$discountpercentage = $_POST["discountpercentage"] ?? [];
$taxvalue = $_POST["taxvalue"] ?? [];
$taxpercentage = $_POST["taxpercentage"] ?? [];
$customerid = $_POST["customerid"] ?? null;
$grandtotal = $_POST["grandtotal"] ?? null;
$invoicedate = $_POST["invoicedate"] ?? null;
$amount = $_POST["amount"] ?? [];
$shipping = $_POST["shipping"] ?? null;
$roundoff = $_POST["roundoff"] ?? null;
$totaltax = $_POST["totaltax"] ?? null;
$invoiceprimaryid = $_POST["invoiceprimaryid"] ?? null;
$totalsavings = $_POST["totalsavings"] ?? null;
$balance= $_POST["balance"]??null;
$paymentstatus= $_POST["paymentstatus"]??null;

// Debugging: Log captured POST data
file_put_contents('debug_log.txt', "Captured POST Data:\n" . print_r([
    'productid' => $productid,
    'invoiceid' => $invoiceid,
    'mrp' => $mrp,
    'qty' => $qty,
    'price' => $price,
    'discountvalue' => $discountvalue,
    'discountpercentage' => $discountpercentage,
    'taxvalue' => $taxvalue,
    'taxpercentage' => $taxpercentage,
    'customerid' => $customerid,
    'grandtotal' => $grandtotal,
    'invoicedate' => $invoicedate,
    'amount' => $amount,
    'shipping' => $shipping,
    'roundoff' => $roundoff,
    'totaltax' => $totaltax,
    'invoiceprimaryid' => $invoiceprimaryid,
    'totalsavings' => $totalsavings,
    'paymentstatus'=>$paymentstatus
], true) . "\n", FILE_APPEND);



try {
    // Update invoice
    $sqlinvoice = "UPDATE invoice SET customerid='$customerid', grandtotal='$grandtotal', shipping='$shipping', roundoff='$roundoff', totaltax='$totaltax', totalsavings='$totalsavings', balance='$balance', paymentstatus='$paymentstatus' WHERE orderid='$invoiceid'";
    if (!mysqli_query($connection, $sqlinvoice)) {
        throw new Exception("Error updating invoice: " . mysqli_error($connection));
    }

    // Update orders
    $sql = "UPDATE orders SET createdate='$invoicedate', customerid='$customerid', grandtotal='$grandtotal', shipping='$shipping', roundoff='$roundoff', total_tax='$totaltax', totalsavings='$totalsavings', balance='$balance', paymentstatus='$paymentstatus' WHERE id='$invoiceid'";
    if (!mysqli_query($connection, $sql)) {
        throw new Exception("Error updating order: " . mysqli_error($connection));
    }

    // Delete previous records
    $deleteOrderdatas = "DELETE FROM orderdatas WHERE orderid='$invoiceid'";
    $deleteInvoicedata = "DELETE FROM invoicedata WHERE invoiceid='$invoiceid'";
    if (!mysqli_query($connection, $deleteOrderdatas) || !mysqli_query($connection, $deleteInvoicedata)) {
        throw new Exception("Error deleting previous records: " . mysqli_error($connection));
    }

    // Insert new records
    for ($count = 0; $count < count($productid); $count++) {
        $item_name_clean = mysqli_real_escape_string($connection, $productid[$count]);
        $mrp_clean = mysqli_real_escape_string($connection, $mrp[$count]);
        $qty_clean = mysqli_real_escape_string($connection, $qty[$count]);
        $price_clean = mysqli_real_escape_string($connection, $price[$count]);
        $discountvalue_clean = mysqli_real_escape_string($connection, $discountvalue[$count]);
        $discountpercentage_clean = mysqli_real_escape_string($connection, $discountpercentage[$count]);
        $taxvalue_clean = mysqli_real_escape_string($connection, $taxvalue[$count]);
        $taxpercentage_clean = mysqli_real_escape_string($connection, $taxpercentage[$count]);
        $amount_clean = mysqli_real_escape_string($connection, $amount[$count]);

        $sqlOrderdatas = "INSERT INTO orderdatas (orderid, productid, mrp, qty, price, discountvalue, discountpercentage, taxvalue, taxpercentage, producttotal) VALUES ('$invoiceid', '$item_name_clean', '$mrp_clean', '$qty_clean', '$price_clean', '$discountvalue_clean', '$discountpercentage_clean', '$taxvalue_clean', '$taxpercentage_clean', '$amount_clean')";
        $sqlInvoicedata = "INSERT INTO invoicedata (invoiceid, productid, mrp, qty, price, discountvalue, discountpercentage, taxvalue, taxpercentage, amount) VALUES ('$invoiceprimaryid', '$item_name_clean', '$mrp_clean', '$qty_clean', '$price_clean', '$discountvalue_clean', '$discountpercentage_clean', '$taxvalue_clean', '$taxpercentage_clean', '$amount_clean')";

        if (!mysqli_query($connection, $sqlOrderdatas) || !mysqli_query($connection, $sqlInvoicedata)) {
            throw new Exception("Error inserting records: " . mysqli_error($connection));
        }
    }

    mysqli_commit($connection); // Commit transaction
    $response = ['delete' => "Previous records deleted successfully.", 'insert' => "New records inserted successfully."];
} catch (Exception $e) {
    mysqli_rollback($connection); // Rollback transaction on error
    $response = ['invoice' => "Error updating invoice: " . $e->getMessage(), 'order' => "Error updating order: " . $e->getMessage()];
}

mysqli_autocommit($connection, TRUE); // Turn autocommit back on
echo json_encode($response);

?>