<?php
include_once 'db.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if required POST variables are set
if (isset($_POST['invoicedate'], $_POST['estid'], $_POST['productid'], $_POST['mrp'],
    $_POST['qty'], $_POST['price'], $_POST['discountvalue'], $_POST['discountpercentage'], $_POST['amountspan'],
    $_POST['taxvalue'], $_POST['taxpercentage'], $_POST['customerid'], $_POST['shipping'], $_POST['roundoff'],
    $_POST['grandtotal'],$_POST['balance'], $_POST['status']
)) {
    $invoicedate = mysqli_real_escape_string($connection, $_POST['invoicedate']);
    $estid = mysqli_real_escape_string($connection, $_POST['estid']);
    $productid = $_POST['productid']; // Expecting array
    $mrp = $_POST['mrp']; // Expecting array
    $qty = $_POST['qty']; // Expecting array
    $price = $_POST['price']; // Expecting array
    $discountvalue = $_POST['discountvalue']; // Expecting array
    $discountpercentage = $_POST['discountpercentage']; // Expecting array
    $amountspan = $_POST['amountspan']; // Expecting array
    $taxvalue = $_POST['taxvalue']; // Expecting array
    $taxpercentage = $_POST['taxpercentage']; // Expecting array
    $customerid = mysqli_real_escape_string($connection, $_POST['customerid']);
    $shipping = mysqli_real_escape_string($connection, $_POST['shipping']);
    $roundoff = mysqli_real_escape_string($connection, $_POST['roundoff']);
    $grandtotal = mysqli_real_escape_string($connection, $_POST['grandtotal']);
    $balance = mysqli_real_escape_string($connection, $_POST['balance']);
    $status = mysqli_real_escape_string($connection, $_POST['status']);
    // Validate required fields
    if (empty($invoicedate) || empty($estid) || empty($productid) || empty($mrp) || empty($qty) || empty($price)) {
        echo json_encode(['error' => "Some required POST variables are missing or empty."]);
        exit();
    }

    // Update purchase table
    $discountvalueSum = array_sum($discountvalue);
    $discountpercentageSum = array_sum($discountpercentage); // Or calculate as needed

    $updateQuery = "UPDATE purchase 
                    SET purchasedate='$invoicedate', shipping='$shipping', roundoff='$roundoff', 
                        grandtotal='$grandtotal', discountvalue='$discountvalueSum', discountpercentage='$discountpercentageSum' , balance='$balance', status='$status'
                    WHERE id='$estid'";
    if (!mysqli_query($connection, $updateQuery)) {
        echo json_encode(['error' => "Update failed: " . mysqli_error($connection)]);
        exit();
    }

    // Delete old purchase data
    $deleteQuery = "DELETE FROM purchasedata WHERE purchaseid='$estid'";
    if (!mysqli_query($connection, $deleteQuery)) {
        echo json_encode(['error' => "Delete failed: " . mysqli_error($connection)]);
        exit();
    }

    // Prepare and execute insert query
    if (is_array($productid) && count($productid) > 0) {
        $insertQuery = "INSERT INTO purchasedata 
                        (purchaseid, productid, mrp, qty, price, discountvalue, discountpercentage, taxvalue, taxpercentage, amount) VALUES ";
        $valuesArr = [];
        for ($count = 0; $count < count($productid); $count++) {
            $valuesArr[] = "('$estid', '{$productid[$count]}', '{$mrp[$count]}', '{$qty[$count]}', '{$price[$count]}', 
                           '{$discountvalue[$count]}', '{$discountpercentage[$count]}', '{$taxvalue[$count]}', 
                           '{$taxpercentage[$count]}', '{$amountspan[$count]}')";
        }
        $insertQuery .= implode(', ', $valuesArr);
        if (!mysqli_query($connection, $insertQuery)) {
            echo json_encode(['error' => "Insert failed: " . mysqli_error($connection)]);
            exit();
        }
    } else {
        echo json_encode(['error' => "Product data is missing or invalid."]);
        exit();
    }

    echo json_encode(['success' => true]);

} else {
    echo json_encode(['error' => "Required POST variables missing."]);
}

mysqli_close($connection);
?>
