<?php
include_once 'db.php';

$invoiceid = isset($_POST['estid']) ? mysqli_real_escape_string($connection, $_POST['estid']) : '';

$sql = "
    SELECT  ed.productid, ed.mrp, ed.price, ed.qty, ed.discountvalue, ed.discountpercentage, ed.taxvalue, ed.taxpercentage, ed.producttotal, ed.roundoff, ed.shipping
    FROM estimatedata ed WHERE ed.estimateid ='$invoiceid'
    ";

$sqlexecute = mysqli_query($connection, $sql);

if (!$sqlexecute) {
    echo json_encode(['error' => 'Failed to execute query: ' . mysqli_error($connection)]);
    exit();
}

$orders = []; // Array to hold tax values for console logging
$taxvalueArray = []; // Array to hold tax values for debugging

while ($row = mysqli_fetch_assoc($sqlexecute)) {
    $productid = $row['productid'];
    $mrp = $row['mrp'];
    $price = $row['price'];  // Remove saleprice if not needed
    $discountvalue = $row['discountvalue'];
    $discountpercentage = $row['discountpercentage'];
    $qty = $row['qty'];
    $amount = $row['producttotal'];
    $taxvalue = $row['taxvalue'];
    $taxpercentage = $row['taxpercentage'];
    
    // Query to fetch product details
    $sqls = "SELECT id, productname FROM product WHERE id = '$productid' AND delete_status = '0'";
    $productResult = mysqli_query($connection, $sqls);

    if (!$productResult) {
        echo json_encode(['error' => 'Failed to execute query: ' . mysqli_error($connection)]);
        exit();
    }

    $product = mysqli_fetch_assoc($productResult);
    $productname = $product['productname'];

    // Add order data to the array
    $orders[] = [
        'productid' => $productid,
        'productname' => $productname,
        'mrp' => $mrp,
        'price' => $price,  // Remove saleprice if not needed
        'discountvalue' => $discountvalue,
        'discountpercentage' => $discountpercentage,
        'qty' => $qty,
        'amount' => $amount,
        'taxvalue' => $taxvalue,
        'taxpercentage' => $taxpercentage
    ];

    // Collect tax values for debugging
    $taxvalueArray[] = $taxvalue;
}

// Output the results as HTML rows
foreach ($orders as $order) {
    echo "<tr class='align-items-top'>
        <td class='align-items-top productname'>
            {$order['productname']}
            <input type='hidden' id='productid' class='productid' name='productid[]' value='{$order['productid']}'>
        </td>
        <td>
            <button type='button' name='remove' id='removeicon' class='' style='color:blue; font-weight:300; top: -100px; border:none;'>
                <i class='dw dw-cancel'></i>
            </button>
        </td>
        <td></td>
        <td class='align-items-top'>
            <input type='text' name='mrp[]' class='invTable mrp' value='{$order['mrp']}'>
        </td>
        <td class='align-items-top'>
            <input type='text' class='invTable price' name='price[]' value='{$order['price']}'>
        </td>
        <td class='align-items-top'>
            <input type='text' class='invTable discountvalue' name='discountvalue[]' value='{$order['discountvalue']}'>
            <br>
            <div style='position: relative; display: inline-block;'>
                <input class='invTable discountpercentage' name='discountpercentage[]' value='{$order['discountpercentage']}' style='margin-top:5px;' type='text'>
                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>
            </div>
        </td>
        <td class='align-items-top'>
            <input type='text' class='invTable qty' name='qty[]' value='{$order['qty']}'>
        </td>
        <td class='align-items-top'>
            <div style='position: relative; display: inline-block;'>
                <input type='text' name='taxpercentage[]' class='invTable taxpercentage' value='{$order['taxpercentage']}' style='padding-right: 20px; box-sizing: border-box;'>
                <span style='position: absolute; right: 5px; top: 50%; transform: translateY(-50%); font-weight: bold;'>%</span>
            </div>
            <br>
            <span class='taxvalue'>₹" . number_format($order['taxvalue'], 2) . "</span>
        </td>
        <td></td>
        <td class='align-items-top amountspan'>" . number_format($order['amount'], 2) . "</td>
    </tr>";
}

// Output tax values to the console
echo "<script>console.log('Tax Values: " . json_encode($taxvalueArray) . "');</script>";

// Close the database connection
mysqli_close($connection);
?>
