<?php 

include_once 'db.php';   



$id = $_GET['id'];



// Fetch data from the estimate table

$sql = "SELECT * FROM estimate WHERE id='$id'";

$queryexecute = mysqli_query($connection, $sql);

$row = mysqli_fetch_array($queryexecute);



// Extract fields with null coalescing operator to avoid undefined index error

$customerid = $row['customerid'] ?? null;

$displayname= $row['displayname'] ?? null;

$entrydate = $row['entrydate'] ?? null;

$estdate = $row['estdate'] ?? null;

$grandtotal = $row['grandtotal'] ?? 0;

$shipping = $row['shipping'] ?? 0;

$roundoff = $row['roundoff'] ?? 0;

$totaltax = $row['totaltax'] ?? 0; // Default to 0 if not set

$totalsavings = $row['totalsavings'] ?? 0;

$discountvalue = $row['discountvalue'] ?? 0;

$discountpercentage = $row['discountpercentage'] ?? 0;



$currentdate = date('Y-m-d');



// Generate invoice number

$invoicenogeneratorquery = "SELECT invoiceno FROM invoice ORDER BY id DESC LIMIT 1";   

$invoicenogeneratorexecute = mysqli_query($connection, $invoicenogeneratorquery);     

$invoicenofetch = mysqli_fetch_array($invoicenogeneratorexecute);  

$invoiceno = $invoicenofetch['invoiceno'] ?? 'INV-00001';

$arr = explode("-", $invoiceno);

$value = isset($arr[1]) ? $arr[1] + 1 : 1;

$values = 'INV-' . str_pad($value, 5, "0", STR_PAD_LEFT);  



// Insert into invoice table

$sql = "INSERT INTO invoice (invoiceno,estimateid, invoicedate, customerid,displayname, grandtotal, shipping, roundoff, totaltax, totalsavings, orderid, store_status, balance, paymentstatus)

        VALUES ('$values', '$id','$currentdate', '$customerid','$displayname', '$grandtotal', '$shipping', '$roundoff', '$totaltax', '$totalsavings', '', '1','$grandtotal','0')";

$queryexecute = mysqli_query($connection, $sql);   

$invoicelastid = $connection->insert_id;



// Initialize arrays to avoid array operator errors

$productid = [];

$mrp = [];

$qty = [];

$price = [];

$discountvalue = [];

$discountpercentage = [];

$taxvalue = [];

$taxpercentagedrodown = [];

$amount = [];



// Fetch data from the estimatedata table

$sql = "SELECT * FROM estimatedata WHERE estimateid='$id'";

$queryexecute = mysqli_query($connection, $sql);

while ($row = mysqli_fetch_array($queryexecute)) {

    $productid[] = $row['productid'];

    $mrp[] = $row['mrp'];

    $qty[] = $row['qty'];

    $price[] = $row['price'];

    $discountvalue[] = $row['discountvalue'];

    $discountpercentage[] = $row['discountpercentage'];

    $taxvalue[] = $row['taxvalue'];

    $taxpercentagedrodown[] = $row['taxpercentage']; // Update this to your column name

    $amount[] = $row['producttotal'];

}



$key = 0;

foreach ($productid as $productId) {

    // Clean the input data

    $productId_clean = mysqli_real_escape_string($connection, $productId);

    $mrp_clean = mysqli_real_escape_string($connection, $mrp[$key]);

    $qty_clean = mysqli_real_escape_string($connection, $qty[$key]);

    $price_clean = mysqli_real_escape_string($connection, $price[$key]);

    $discountvalue_clean = mysqli_real_escape_string($connection, $discountvalue[$key]);

    $discountpercentage_clean = mysqli_real_escape_string($connection, $discountpercentage[$key]);

    $taxvalue_clean = mysqli_real_escape_string($connection, $taxvalue[$key]);

    $taxpercentagedrodown_clean = mysqli_real_escape_string($connection, $taxpercentagedrodown[$key]);

    $amount_clean = mysqli_real_escape_string($connection, $amount[$key]);



    // Insert into invoicedata table

    $sqls = "INSERT INTO invoicedata (invoiceid, productid, mrp, qty, price, discountvalue, discountpercentage, taxvalue, taxpercentage, amount)

             VALUES ('$invoicelastid', '$productId_clean', '$mrp_clean', '$qty_clean', '$price_clean', '$discountvalue_clean', 

                     '$discountpercentage_clean', '$taxvalue_clean', '$taxpercentagedrodown_clean', '$amount_clean')";

    $querys = mysqli_query($connection, $sqls);

    if (!$querys) {

        die('Error inserting data: ' . mysqli_error($connection));

    }



    // Update the product quantity in the product table

    $sqlsquery = "UPDATE product SET qty = qty - '$qty_clean' WHERE id = '$productId_clean'";

    $querysquery = mysqli_query($connection, $sqlsquery);

    if (!$querysquery) {

        die('Error updating product: ' . mysqli_error($connection));

    }



    // Increment key after each iteration

    $key++;

}







if ($invoicelastid) {

    // Fetch profile data

    $querys = mysqli_query($connection, "SELECT * FROM profile");

    if (!$querys) {

        die('Error fetching profile data: ' . mysqli_error($connection));

    }

    $profileselect = mysqli_fetch_array($querys);

    

    // Assign profile data to variables with default values

    $storename = $profileselect['storename'] ?? 'Default Store Name';

    $email = $profileselect['email'] ?? 'no-reply@example.com'; 

    $street1 = $profileselect['street1'] ?? '';

    $street2 = $profileselect['street2'] ?? '';

    $city = $profileselect['city'] ?? '';

    $state = $profileselect['state'] ?? '';

    $pincode = $profileselect['pincode'] ?? '';

    $phonenumber = $profileselect['phonenumber'] ?? '';

    $gstno = $profileselect['gstnumber'] ?? '';

    $logopath = $profileselect['logopath'] ?? '';

    $notes = $profileselect['notes'] ?? '';

    $accountno = $profileselect['account'] ?? '';

    $ifsc = $profileselect['ifsc'] ?? '';

    $bank = $profileselect['bankname'] ?? '';

    $upiid = $profileselect['upiid'] ?? '';



    // Fetch invoice information

    $query = "SELECT i.id, i.invoiceno, i.invoicedate, c.displayname, c.phoneno, c.address, c.city, c.pincode, c.gstno, c.email, i.orderid, i.customerid,i.grandtotal

              FROM invoice i 

              INNER JOIN customer c ON c.id = '$customerid'

              WHERE i.id = '$invoicelastid'";

    $result = mysqli_query($connection, $query);

    if (!$result) {

        die('Query failed: ' . mysqli_error($connection));

    }

    $row = mysqli_fetch_array($result);

    

    // Extract customer and invoice details

    $invoiceid= $row['id'];

    $invoiceno = $row['invoiceno'];

    $invoicedate = $row['invoicedate'];

    $customerid = $row['customerid'];

    $customername = $row['displayname'];

    $customerphone = $row['phoneno'];

    $customeraddress = $row['address'];

    $customercity = $row['city'];

    $customerpincode = $row['pincode'];

    $customergstno = $row['gstno'];

    $customeremail = $row['email'];

    $orderid = $row['orderid'];

    $grandtotal= $row['grandtotal'];

    

    // Fetch invoice settings

    $query1 = mysqli_query($connection, "SELECT * FROM invoicesetting WHERE 1");

    if (!$query1) {

        die('Error fetching invoice settings: ' . mysqli_error($connection));

    }

    $terms = mysqli_fetch_array($query1);



  



    // Prepare for PDF details insertion

    $sqlInsert = "INSERT INTO invoicepdfdetails 

        (invoiceno,invoiceid,orderid, invoicedate, customerid,totalsavings, grandtotal, storename, email, street1,street2, city, state, pincode, phonenumber, gstnumber, logopath, notes, account, ifsc, bankname, displayname, phoneno, address, customer_city, customer_pincode, customer_gstno, customer_email,upiid, terms, qrcode) 

        VALUES 

        ('$invoiceno','$invoiceid', '$orderno', '$invoicedate', '$customerid','$totalsavings','$grandtotal', '$storename', '$email', '$street1','$street2', '$city', '$state', '$pincode', '$phonenumber', '$gstno', '$logopath', '$notes', '$accountno', '$ifsc', '$bank', '$customername', '$customerphone', '$customeraddress', '$customercity', '$customerpincode', '$customergstno', '$customeremail','$upiid', '".$terms['terms']."', '".$terms['qrcode']."')";



    if (!mysqli_query($connection, $sqlInsert)) {

        die('Error inserting invoice PDF details: ' . mysqli_error($connection));

    } else {

        echo "Data inserted successfully!";

        header("Location: estimate.php");

    }

} else {

    echo "Error: No invoice ID provided.";

}

?>