<?php

session_start();



// Check session for authentication

if (empty($_SESSION['username'])) {

    echo json_encode(['status' => 'error', 'message' => 'Unauthorized access']);

    exit();

}

include_once 'db.php';  // Include your database connection script



if (isset($_POST['orderid'])) {

    $orderid = $_POST['orderid'];



    // Prepare SQL query

    $query = "SELECT orderid, actionstatus FROM `orders` WHERE id = ?";

    $stmt = $connection->prepare($query);



    if (!$stmt) {

        echo json_encode(['status' => 'error', 'message' => 'Database query preparation error']);

        exit();

    }



    // Bind parameters and execute query

    $stmt->bind_param("i", $orderid);

    $stmt->execute();



    // Get results

    $result = $stmt->get_result();



    if ($result->num_rows > 0) {

        // Fetch data

        $data = $result->fetch_assoc();

        echo json_encode(['status' => 'success', 'orderid' => $data['orderid'], 'actionstatus' => $data['actionstatus']]);

    } else {

        // No data found

        echo json_encode(['status' => 'error', 'message' => 'No data found']);

    }

} else {

    // Order ID not provided

    echo json_encode(['status' => 'error', 'message' => 'Order ID not provided']);

}

?>

