<?php 
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once 'db.php'; // Ensure this path is correct

// Verify connection
if (!$connection) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection not established.']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['purchaseid'])) {
    $purchaseid = intval($_POST['purchaseid']);

    try {
        // Fetch total payments from vendorpayment
        $stmt = $connection->prepare("SELECT SUM(amount) AS total_amount FROM vendorpayment WHERE purchaseid = ?");
        if (!$stmt) {
            throw new Exception("Database query preparation failed: " . $connection->error);
        }

        $stmt->bind_param("i", $purchaseid);
        
        if (!$stmt->execute()) {
            throw new Exception("Database query execution failed: " . $stmt->error);
        }

        $result = $stmt->get_result();
        $total_amount = 0;
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $total_amount = $row['total_amount'];
        }

        $stmt->close();

        // Fetch grandtotal from purchase table
        $stmt = $connection->prepare("SELECT grandtotal FROM purchase WHERE id = ?");
        if (!$stmt) {
            throw new Exception("Database query preparation failed: " . $connection->error);
        }

        $stmt->bind_param("i", $purchaseid);
        
        if (!$stmt->execute()) {
            throw new Exception("Database query execution failed: " . $stmt->error);
        }

        $result = $stmt->get_result();
        $grandtotal = 0;
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $grandtotal = $row['grandtotal'];
        }

        $stmt->close();

        // Calculate balance
        $balance = $grandtotal - $total_amount;

        // Send the result as JSON
        echo json_encode(['balance' => $balance]);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid request']);
}

if (isset($connection)) {
    $connection->close();
}
?>
