<?php
header('Content-Type: application/json'); // Ensure the response is JSON

if (isset($_FILES['image'])) {
    $target_dir = "images/category/";
    $image_name = basename($_FILES['image']['name']);
    $unique_name = uniqid() . '-' . $image_name;
    $target_file = $target_dir . $unique_name;

    // Validate file
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
    $check = getimagesize($_FILES['image']['tmp_name']);
    if ($check === false) {
        echo json_encode(['status' => 'error', 'message' => 'File is not an image.']);
        exit;
    }

    if ($_FILES['image']['size'] > 5000000) {
        echo json_encode(['status' => 'error', 'message' => 'File size is too large.']);
        exit;
    }

    if (!in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif'])) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid file format.']);
        exit;
    }

    // Move file
    if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
        echo json_encode(['status' => 'success', 'image_path' => $target_file]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to upload image.']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'No image file found.']);
}
?>
