<?php 
include_once 'db.php';   

// Extract POST variables and add checks for undefined array keys
$invoicedate = isset($_POST["invoicedate"]) ? $_POST["invoicedate"] : '';  
$customerid = isset($_POST["customerid"]) ? $_POST["customerid"] : '';  
$grandtotal = isset($_POST["grandtotal"]) ? $_POST["grandtotal"] : 0;  
$productid = isset($_POST["productid"]) ? $_POST["productid"] : [];  
$mrp = isset($_POST["mrp"]) ? $_POST["mrp"] : [];  
$qty = isset($_POST["qty"]) ? $_POST["qty"] : [];  
$price = isset($_POST["price"]) ? $_POST["price"] : [];  
$discountvalue = isset($_POST["discountvalue"]) ? $_POST["discountvalue"] : [];  
$discountpercentage = isset($_POST["discountpercentage"]) ? $_POST["discountpercentage"] : [];  
$taxvalue = isset($_POST["taxvalue"]) ? $_POST["taxvalue"] : [];  
$taxpercentage = isset($_POST["taxpercentage"]) ? $_POST["taxpercentage"] : [];  
$amount = isset($_POST["amount"]) ? $_POST["amount"] : [];  
$shipping = isset($_POST["shipping"]) ? $_POST["shipping"] : 0;  
$roundoff = isset($_POST["roundoff"]) ? $_POST["roundoff"] : 0;  
$totaltax = isset($_POST["totaltax"]) ? $_POST["totaltax"] : 0;  
$totalsavings = isset($_POST["totalsavings"]) ? $_POST["totalsavings"] : 0;  

$currentDate = date("Y-m-d");

// Generate the estimate number
$invoicenogeneratorquery = "SELECT estimateno FROM estimate ORDER BY id DESC LIMIT 1";   
$invoicenogeneratorexecute = mysqli_query($connection, $invoicenogeneratorquery); 
$invoicenofetch = mysqli_fetch_array($invoicenogeneratorexecute);  
$estimateno = isset($invoicenofetch['estimateno']) ? $invoicenofetch['estimateno'] : ''; 

if ($estimateno == "") {
    $estimateno = '1';
} else {
    $estimateno = $invoicenofetch['estimateno'];
}

$arr  = explode("-", $estimateno);   
$value = $arr[1] + 1;      
$values = 'EST-' . str_pad($value, 5, "0", STR_PAD_LEFT);  

// Calculate subtotal (sum of amounts)
$subtotal = 0;
foreach ($amount as $amt) {
    $subtotal += $amt;
}

// Insert into estimate table
$sql = "INSERT INTO estimate (estimateno, estdate, customerid, subtotal, tax, discountvalue, discountpercentage, grandtotal, shipping, roundoff, total_tax, entrydate, totalsavings)
        VALUES ('$values', '$invoicedate', '$customerid', '$subtotal', '$totaltax', '$totalsavings', '$discountpercentage[0]', '$grandtotal', '$shipping', '$roundoff', '$totaltax', '$currentDate', '$totalsavings')";   
$queryexecute = mysqli_query($connection, $sql); 

if (!$queryexecute) {
    die('Error: ' . mysqli_error($connection));
}

// Get the last inserted ID for the estimate
$lastInsertID = mysqli_insert_id($connection);

if ($lastInsertID && is_array($productid)) {
    // Insert into estimatedata table for each product
    for ($count = 0; $count < count($productid); $count++) {
        $item_name = $productid[$count];
        $mrp_value = $mrp[$count];
        $qty_value = $qty[$count];
        $price_value = $price[$count];
        $discountvalue_value = isset($discountvalue[$count]) ? $discountvalue[$count] : 0;
        $discountpercentage_value = isset($discountpercentage[$count]) ? $discountpercentage[$count] : 0;
        $taxpercentage_value = isset($taxpercentage[$count]) ? $taxpercentage[$count]  : 0;
        $taxvalue_value = $taxpercentage_value > 0 ? ($taxpercentage_value / 100) * $price_value : 0; // Calculate tax value if tax percentage is greater than 0
        $amount_value = isset($amount[$count]) ? $amount[$count] : 0;
        $producttotal = ($price_value * $qty_value) + $taxvalue_value;

        $sql = "INSERT INTO estimatedata (estimateid, productid, mrp, qty, price, discountvalue, discountpercentage, taxvalue, taxpercentage, producttotal, roundoff, shipping)
                VALUES ('$lastInsertID', '$item_name', '$mrp_value', '$qty_value', '$price_value', '$discountvalue_value', '$discountpercentage_value', '$taxvalue_value', '$taxpercentage_value', '$producttotal', '$roundoff', '$shipping')";  

        $queryexecute = mysqli_query($connection, $sql); 

        if (!$queryexecute) {
            die('Error: ' . mysqli_error($connection));
        }
    }
} else {
    die('Error: Could not retrieve last inserted ID or productid is not an array.');
}

echo "Estimate and estimatedata inserted successfully.";

?>
