<?php
include_once 'db.php';

// Debugging: Check if POST data is received
file_put_contents('debug.txt', print_r($_POST, true));

// Validate and sanitize input
$productid = isset($_POST["productid"]) ? array_map('intval', $_POST["productid"]) : [];
$mrp = isset($_POST["mrp"]) ? array_map('floatval', $_POST["mrp"]) : [];
$qty = isset($_POST["qty"]) ? array_map('intval', $_POST["qty"]) : [];
$price = isset($_POST["price"]) ? array_map('floatval', $_POST["price"]) : [];
$discountvalue = isset($_POST["discountvalue"]) ? array_map('floatval', $_POST["discountvalue"]) : [];
$discountpercentage = isset($_POST["discountpercentage"]) ? array_map('floatval', $_POST["discountpercentage"]) : [];
$taxvalue = isset($_POST["taxvalue"]) ? array_map('floatval', $_POST["taxvalue"]) : [];
$taxpercentage = isset($_POST["taxpercentage"]) ? array_map('floatval', $_POST["taxpercentage"]) : [];
$customerid = isset($_POST["customerid"]) ? intval($_POST["customerid"]) : 0;
$grandtotal = isset($_POST["grandtotal"]) ? floatval($_POST["grandtotal"]) : 0;
$invoicedate = isset($_POST["invoicedate"]) ? $_POST["invoicedate"] : date('Y-m-d');
$duedate = isset($_POST["duedate"]) ? $_POST["duedate"] : date('Y-m-d', strtotime('+30 days'));
$amount = isset($_POST["amount"]) ? array_map('floatval', $_POST["amount"]) : [];
$shipping = isset($_POST["shipping"]) ? floatval($_POST["shipping"]) : 0;
$roundoff = isset($_POST["roundoff"]) ? floatval($_POST["roundoff"]) : 0;
$orderid = isset($_POST["orderid"]) ? intval($_POST["orderid"]) : 0;
$totaltax = isset($_POST["totaltax"]) ? floatval($_POST["totaltax"]) : 0;
$totalsavings = isset($_POST["totalsavings"]) ? floatval($_POST["totalsavings"]) : 0;
$balance = isset($_POST["balance"]) ? floatval($_POST["balance"]) : 0;
$status = isset($_POST["status"]) ? $_POST["status"] : 'Pending';

// Aggregate discount values and percentages
$total_discount_value = array_sum($discountvalue);
$average_discount_percentage = count($discountpercentage) > 0 ? array_sum($discountpercentage) / count($discountpercentage) : 0;

// Fetch the last purchase number and generate a new one
$invoicenogeneratorquery = "SELECT purchaseno FROM purchase ORDER BY id DESC LIMIT 1";
$invoicenogeneratorexecute = mysqli_query($connection, $invoicenogeneratorquery);
if (!$invoicenogeneratorexecute) {
    die('Error fetching last purchase number: ' . mysqli_error($connection));
}
$invoicenofetch = mysqli_fetch_array($invoicenogeneratorexecute);

$purchaseno = $invoicenofetch['purchaseno'] ?? '';

if (empty($purchaseno)) {
    $purchaseno = '1';
} else {
    $arr = explode("-", $purchaseno);
    $value = $arr[1] + 1;
    $purchaseno = 'PO-' . str_pad($value, 5, "0", STR_PAD_LEFT);
}

// Insert into purchase table
$sql = "INSERT INTO purchase SET 
    purchaseno='$purchaseno', 
    purchasedate='$invoicedate', 
    duedate='$duedate', 
    vendorid='$customerid', 
    grandtotal='$grandtotal', 
    shipping='$shipping', 
    roundoff='$roundoff', 
    total_tax='$totaltax', 
    totalsavings='$totalsavings', 
    balance='$balance', 
    discountpercentage='$average_discount_percentage', 
    discountvalue='$total_discount_value',
    status='$status'";

$queryexecute = mysqli_query($connection, $sql);

if ($queryexecute) {
    $lastInsertID = mysqli_insert_id($connection);
    echo $lastInsertID;

    // Fetch profile data
    $querys = mysqli_query($connection, "SELECT * FROM profile");
    if (!$querys) {
        die('Error fetching profile data: ' . mysqli_error($connection));
    }
    $profileselect = mysqli_fetch_array($querys);

    // Assign profile data to variables with default values
    $storename = $profileselect['storename'] ?? 'Default Store Name';
    $email = $profileselect['email'] ?? 'no-reply@example.com'; 
    $street1 = $profileselect['street1'] ?? '';
    $street2 = $profileselect['street2'] ?? '';
    $city = $profileselect['city'] ?? '';
    $state = $profileselect['state'] ?? '';
    $pincode = $profileselect['pincode'] ?? '';
    $phonenumber = $profileselect['phonenumber'] ?? '';
    $gstno = $profileselect['gstnumber'] ?? '';
    $logopath = $profileselect['logopath'] ?? '';
    $notes = $profileselect['notes'] ?? '';
    $accountno = $profileselect['account'] ?? '';
    $ifsc = $profileselect['ifsc'] ?? '';
    $bank = $profileselect['bankname'] ?? '';
    $upiid = $profileselect['upiid'] ?? '';

    // Fetch invoice information
    $query = "SELECT p.id, p.purchaseno, p.purchasedate,  c.displayname, c.phoneno, c.address, c.city, c.pincode, c.gstno, c.email, p.vendorid, p.grandtotal
              FROM purchase p
              INNER JOIN vendor c ON c.id = '$customerid'
              WHERE p.id = '$lastInsertID'";
    $result = mysqli_query($connection, $query);
    if (!$result) {
        die('Query failed: ' . mysqli_error($connection));
    }
    $row = mysqli_fetch_array($result);

    // Extract customer and invoice details
    $purchaseid = $row['id'];
    $purchaseno = $row['purchaseno'];
    $purchasedate = $row['purchasedate'];
    $customerid = $row['vendorid'];
    $customername = $row['displayname'];
    $customerphone = $row['phoneno'];
    $customeraddress = $row['address'];
    $customercity = $row['city'];
    $customerpincode = $row['pincode'];
    $customergstno = $row['gstno'];
    $customeremail = $row['email'];
    $grandtotal = $row['grandtotal'];

    // Fetch invoice settings
    $query1 = mysqli_query($connection, "SELECT * FROM invoicesetting WHERE 1");
    if (!$query1) {
        die('Error fetching invoice settings: ' . mysqli_error($connection));
    }
    $terms = mysqli_fetch_array($query1);

    // Prepare for PDF details insertion
    $sqlInsert = "INSERT INTO purchasepdfdetails 
        (purchaseno,purchaseid, purchasedate, customerid, totalsavings, grandtotal, storename, email, street1, street2, city, state, pincode, phonenumber, gstnumber, logopath, notes, account, ifsc, bankname, displayname, phoneno, address, customer_city, customer_pincode, customer_gstno, customer_email, upiid, terms, qrcode) 
        VALUES 
        ('$purchaseno','$purchaseid', '$purchasedate', '$customerid', '$totalsavings', '$grandtotal', '$storename', '$email', '$street1', '$street2', '$city', '$state', '$pincode', '$phonenumber', '$gstno', '$logopath', '$notes', '$accountno', '$ifsc', '$bank', '$customername', '$customerphone', '$customeraddress', '$customercity', '$customerpincode', '$customergstno', '$customeremail', '$upiid', '".$terms['terms']."', '".$terms['qrcode']."')";

    if (!mysqli_query($connection, $sqlInsert)) {
        die('Error inserting purchase PDF details: ' . mysqli_error($connection));
    } else {
        echo "Data inserted successfully!";
    }

    for ($count = 0; $count < count($productid); $count++) {
        $productid_clean = mysqli_real_escape_string($connection, $productid[$count]);
        $mrp_clean = mysqli_real_escape_string($connection, $mrp[$count]);
        $qty_clean = mysqli_real_escape_string($connection, $qty[$count]);
        $price_clean = mysqli_real_escape_string($connection, $price[$count]);
        $discountvalue_clean = mysqli_real_escape_string($connection, $discountvalue[$count]);
        $discountpercentage_clean = mysqli_real_escape_string($connection, $discountpercentage[$count]);
        $taxpercentage_clean = mysqli_real_escape_string($connection, $taxpercentage[$count]);
        $taxvalue_clean = $taxpercentage_clean / 100 * $price_clean;
        $amount_clean = $qty_clean * $price_clean ;

        $sql = "INSERT INTO purchasedata SET 
            purchaseid='$lastInsertID', 
            productid='$productid_clean', 
            mrp='$mrp_clean', 
            qty='$qty_clean', 
            price='$price_clean', 
            discountvalue='$discountvalue_clean', 
            discountpercentage='$discountpercentage_clean', 
            taxvalue='$taxvalue_clean', 
            taxpercentage='$taxpercentage_clean', 
            amount='$amount_clean'";

        $queryexecute = mysqli_query($connection, $sql);

        if (!$queryexecute) {
            // Error handling for inserting into purchasedata
            echo "Error inserting data for product ID $productid_clean: " . mysqli_error($connection);
        }
    }
} else {
    // Error handling for inserting into purchase
    echo "Error inserting purchase: " . mysqli_error($connection);
}
?>
