<?php
// Include database connection
include_once 'db.php'; 

// Fetch invoice ID from the GET request
$invoiceID = $_GET['invoiceID'];   
error_reporting(0);

// Fetch profile information
$querys = mysqli_query($connection, "SELECT * FROM profile");
$profileselect = mysqli_fetch_array($querys);

// Assign profile data to variables
$storename = $profileselect['storename'];
$email = $profileselect['email']; 
$street1 = $profileselect['street1'];
$city = $profileselect['city'];
$state = $profileselect['state'];
$pincode = $profileselect['pincode'];
$phonenumber = $profileselect['phonenumber'];
$gstno = $profileselect['gstnumber'];
$logopath = $profileselect['logopath'];
$notes = $profileselect['notes'];

// Fetch owner admin information
$querys = mysqli_query($connection, "SELECT * FROM owneradmin");
$owneradminselect = mysqli_fetch_array($querys); 
$qrcode = $owneradminselect['qrcode'];
$company = $owneradminselect['company'];
$bankname = $owneradminselect['bankname'];
$accountno = $owneradminselect['accountno'];
$ifsc = $owneradminselect['ifsc'];

// Fetch invoice information
$query = mysqli_query($connection, "SELECT i.id, i.invoiceno, i.invoicedate, i.grandtotal, i.tax, i.totalsavings, c.displayname, c.phoneno, c.address, c.city, c.pincode, c.gstno, c.email, i.orderid, i.shipping FROM invoice i INNER JOIN customer c ON c.id = i.customerid WHERE i.id = '$invoiceID'");
$invoice = mysqli_fetch_array($query);

$tax = $invoice["tax"];
$estidprimary = $invoice['estidprimary'];
$orderid = $invoice['orderid'];

// Fetch order information
$orderinvoice = "SELECT orderid FROM orders WHERE id='$orderid'";
$orderquery = mysqli_query($connection, $orderinvoice);
$oderfetch = mysqli_fetch_array($orderquery);
$orderid = $oderfetch['orderid'];

// Fetch invoice data
$sqls = "SELECT * FROM invoicedata WHERE invoiceid ='$invoiceID'";
$sqlexecutes = mysqli_query($connection, $sqls);

// Start generating HTML content
$output = '
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Invoice</title>
    <link rel="stylesheet" type="text/css" href="pdfstyle/main-style.css">
    <style>table { page-break-inside: avoid !important; } body { background-color: #f9f9f9; }</style>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        document.getElementById("bill-download").addEventListener("click", function() {
            var element = document.getElementById("download-section");
            var opt = {
                margin: 0.5,
                filename: "invoice.pdf",
                image: { type: "jpeg", quality: 0.98 },
                html2canvas: { scale: 2 },
                jsPDF: { unit: "in", format: "letter", orientation: "portrait" }
            };
            html2pdf().from(element).set(opt).save();
        });
    });
    </script>
</head>
<body>
    <main class="container invoice-wrapper" id="download-section">
        <div class="invoice-top">
            <div class="row align-items-center">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-start mb-3 mb-sm-1">
                    <a href="index.html"><img src="'.$logopath.'" title="invoice" alt="invoice" width="130px"></a>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-end mb-3 mb-sm-1">
                    <h4 class="text-30 mb-0 mt-0">Invoice</h4>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-sm-6"><strong>Invoice Date:</strong> '.date("d-m-Y", strtotime($invoice['invoicedate'])).'</div>
                <div class="col-sm-6 text-sm-end"><strong>Invoice No:</strong> '.$invoice['invoiceno'].'</div>
            </div>
            <hr>
        </div>
        <hr>
        <div class="invoice-details border-top mt-20 pt-20">
            <div class="row">
                <div class="col-sm-6 text-sm-end order-sm-1">
                    <strong class="text-18 mb-3 d-inline-block">Pay To:</strong>
                    <address class="mb-4">
                        <b style="">'.$storename.',</b><br/>
                        '.$street1.' 4/2322/21, Sattur Road '.$street2.',<br/>
                        '.$city.' Viswanatham Panchayat, <br/>
                        '.$pincode.' SIVAKASI<br/>
                        '.$phonenumber.' 96550 32853, 99521 62891<br/>
                        '.$email.'
                    </address>

                </div>
                <div class="col-sm-6 order-sm-0">
                    <strong class="text-18 mb-3 d-inline-block">Invoiced To:</strong>
                    <address class="mb-4">
                        '.trim($invoice['displayname']).'<br>
                        '.trim($invoice['address']).'<br>
                        '.trim($invoice['city']).' '.$invoice['pincode'].'<br>
                        '.$invoice['phoneno'].'<br>
                        '.$invoice['email'].'
                    </address>
                </div>
            </div>
        </div>
        <div class="card mb-3">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table mb-0">
                        <thead class="card-header">
                            <tr>
                                <td class="col-3"><strong>Number</strong></td>
                                <td class="col-3"><strong>Product Name</strong></td>
                                <td class="col-4"><strong>Qty</strong></td>
                                <td class="col-2 text-center"><strong>MRP</strong></td>
                                <td class="col-1 text-center"><strong>Rate</strong></td>
                                <td class="col-2 text-end"><strong>Disc</strong></td>
                                <td class="col-2 text-end"><strong>Tax</strong></td>
                                <td class="col-2 text-end"><strong>Amount</strong></td>
                            </tr>
                        </thead>
                        <tbody>';

$count = 0;
$productsPerPage = 25;
while ($orderrows = mysqli_fetch_array($sqlexecutes)) {
    $count++;
    $productid = $orderrows['productid'];   
    $query2 = mysqli_query($connection, "SELECT * FROM product WHERE id='$productid'");    
    $product = mysqli_fetch_array($query2);
    
    $output .= ' 
        <tr>
            <td class="col-3">'.$count.'</td> 
            <td class="col-3">'.$product['productname'].'</td>  
            <td class="col-4">'.$orderrows['qty'].'</td>  
            <td class="col-2 text-center">'.$orderrows['mrp'].'</td>  
            <td class="col-1 text-center">'.$orderrows['price'].'</td>  
            <td class="col-2 text-end">'.$orderrows['discountvalue'].'</td>  
            <td class="col-2 text-end">'.number_format($orderrows['taxvalue'],2).'</td>  
            <td class="col-2 text-end">'.$orderrows['amount'].'</td>  
        </tr>';   
    
    // Check if it's time for a page break
    if ($count % $productsPerPage == 0) {
        $output .= '</tbody></table><div style="page-break-before:always;"></div><table class="table mb-0"><thead class="card-header"><tr><td class="col-3"><strong>Number</strong></td><td class="col-3"><strong>Product Name</strong></td><td class="col-4"><strong>Qty</strong></td><td class="col-2 text-center"><strong>MRP</strong></td><td class="col-1 text-center"><strong>Rate</strong></td><td class="col-2 text-end"><strong>Disc</strong></td><td class="col-2 text-end"><strong>Tax</strong></td><td class="col-2 text-end"><strong>Amount</strong></td></tr></thead><tbody>';
    }
}

$taxquery = "SELECT taxpercentage, SUM(taxvalue) as taxvalue FROM invoicedata WHERE invoiceid='$invoiceID' GROUP BY taxpercentage"; 
$invoicedataquerys = mysqli_query($connection, $taxquery); 
while ($rowinvoicedatas = mysqli_fetch_array($invoicedataquerys)) {
    $taxs = $rowinvoicedatas['taxpercentage'] / 2; 
    $taxvalue = $rowinvoicedatas['taxvalue'] / 2;  
    if ($taxs != "") {
        $output .= ' 
        <tr>
            <td colspan="7" class="text-end"><strong>CGST@ '. $taxs.'% </strong></td>
            <td class="text-end">'.number_format($taxvalue,2).'</td>       
        </tr>
        <tr>
            <td colspan="7" class="text-end"><strong>SGST@ '. $taxs.'% </strong></td>
            <td class="text-end">'.number_format($taxvalue,2).'</td>       
        </tr>'; 
    }
}

$output .= '
    <tr>
        <td colspan="7" class="text-end"><strong>Total</strong></td>
        <td class="text-end"><strong>'.number_format($invoice['grandtotal'],2).'</strong></td>       
    </tr>
    </tbody>
    </table>
    </div>
    </div>
    </div>
    <div class="invoice-footer text-center mt-20">
        <p>'.$notes.'</p>
    </div>

    <div class="text-center mt-5 mb-4 regular-button">
        <div class="d-print-none d-flex justify-content-center flex-wrap gap-10"> 
            <button id="bill-download" class="btn-primary-outline">Download</button> 
            <a href="javascript:window.print()" class="btn-primary-fill">Print Invoice</a> 
        </div>
    </div>

</main>
</body>
</html>';

// Output the final HTML
echo $output;
?>
