<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Check Shipping Availability</title>
</head>
<body>
    <h2>Enter Your Address</h2>
    <input type="text" id="street" placeholder="Street"><br><br>
    <input type="text" id="city" placeholder="City"><br><br>
    <input type="text" id="state" placeholder="State"><br><br>
    <input type="text" id="pincode" placeholder="Pincode"><br><br>
    <button onclick="geocodeAddress()">Check Availability</button>
    
    <p id="shipping-status"></p>
    
    <script>
        const olaApiKey = "tDhDNdOontnFyzjCD5DNJt1AamjPKZxbWR3Yd4kc"; // Replace with your API Key
        const storeLat = 10.8160;
        const storeLng = 78.6066;
        const storeRadius = 40000; // Radius in meters

        async function geocodeAddress() {
            const street = document.getElementById('street').value;
            const city = document.getElementById('city').value;
            const state = document.getElementById('state').value;
            const pincode = document.getElementById('pincode').value;
            
            if (!street || !city || !state || !pincode) {
                alert("Please enter a complete address.");
                return;
            }

            const address = `${street}, ${city}, ${state}, ${pincode}`;
            const url = `https://api.olamaps.io/places/v1/geocode?address=${encodeURIComponent(address)}&language=en&api_key=${olaApiKey}`;
            
            try {
                const response = await fetch(url, {
                    headers: {
                        "X-Request-Id": "123456789" // You can change this to a unique ID
                    }
                });
                
                const data = await response.json();
                if (data && data.geocodingResults && data.geocodingResults.length > 0) {
                    const location = data.geocodingResults[0].geometry.location;
                    checkAvailability(location.lat, location.lng);
                } else {
                    alert("Geocode was not successful. Please check your input.");
                }
            } catch (error) {
                console.error("Error fetching geocode data:", error);
                alert("Failed to fetch geocode data. Try again later.");
            }
        }

        function checkAvailability(lat, lng) {
            const distance = getDistanceFromLatLonInMeters(storeLat, storeLng, lat, lng);
            
            if (distance <= storeRadius) {
                document.getElementById('shipping-status').innerText = "Shipping Available ✅";
                document.getElementById('shipping-status').style.color = "green";
            } else {
                document.getElementById('shipping-status').innerText = "Shipping Not Available ❌";
                document.getElementById('shipping-status').style.color = "red";
            }
        }

        function getDistanceFromLatLonInMeters(lat1, lon1, lat2, lon2) {
            const R = 6371000; // Radius of Earth in meters
            const dLat = deg2rad(lat2 - lat1);
            const dLon = deg2rad(lon2 - lon1);
            const a = 
                Math.sin(dLat / 2) * Math.sin(dLat / 2) +
                Math.cos(deg2rad(lat1)) * Math.cos(deg2rad(lat2)) * 
                Math.sin(dLon / 2) * Math.sin(dLon / 2);
            const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
            return R * c; // Distance in meters
        }

        function deg2rad(deg) {
            return deg * (Math.PI / 180);
        }
    </script>
</body>
</html>