<?php
include_once 'db.php';

// Start a transaction
mysqli_begin_transaction($connection);

try {
    // Sanitize and prepare the array of product IDs
    $productids = array_map('intval', explode(',', $_POST['productid']));

    foreach ($productids as $productid) {
        // Ensure $productid is an integer and safely build the SQL query
        $productid = intval($productid);

        // Prepare the SQL statement
        $sql = "UPDATE product SET delete_status = 1 WHERE id = $productid";

        // Execute the query
        $result = mysqli_query($connection, $sql);

        // Check if the query was successful
        if (!$result) {
            throw new Exception('Error deleting product ' . $productid . ': ' . mysqli_error($connection));
        }
    }

    // Commit the transaction if all queries succeed
    mysqli_commit($connection);

    echo "Successfully deleted all products.";
} catch (Exception $e) {
    // Rollback the transaction if there was an error
    mysqli_rollback($connection);
    echo "Failed to delete products: " . $e->getMessage();
} finally {
    // Close the connection
    mysqli_close($connection);
}
?>
