<?php

// Get the order ID from the URL
$orderId = $_GET['orderids'] ?? '';

// Check if the order ID is provided
if (!$orderId) {
    echo json_encode([
        "status" => "error",
        "message" => "Order ID is required."
    ]);
    exit;
}

// Define the API URL
$api_url = "https://hapitest.xyz/hapi%20commers/api/getorderpdfdata-api.php";

// Initialize cURL
$ch = curl_init();

// Set cURL options
curl_setopt_array($ch, [
    CURLOPT_URL => $api_url . "?orderId=" . urlencode($orderId),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPGET => true,
]);

// Execute the request
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    echo json_encode([
        "status" => "error",
        "message" => "Failed to fetch data from API.",
        "error_detail" => curl_error($ch)
    ]);
    curl_close($ch);
    exit;
}

// Close cURL
curl_close($ch);

// Decode the JSON response
$data = json_decode($response, true);

// Check if decoding was successful and the API returned a successful response
if (!$data || $data['status'] !== 'success') {
    echo json_encode([
        "status" => "error",
        "message" => "Failed to fetch or decode API response.",
        "api_response" => $response
    ]);
    exit;
}

// Extract profile and order data
$profile = $data['profile'] ?? [];
$order_data = $data['order_data'] ?? [];
$taxvalue = $data['taxvalue'] ?? 0;
$grandtotal = $data['grandtotal'] ?? 0;
$orderdate = $data['orderdate'] ?? '';
$logopath = $profile['logo_path'] ?? '';
$orderno = $data['orderno']??'';
$totalSavings = $data['totalsavings']??'';
$note = $data['note'];
$terms= $data['terms'];
$qrcode =$data['qrcode'];




    // Generate HTML for the invoice

    $output = '

    <!DOCTYPE html>

    <html lang="en">

    <head>

        <meta charset="UTF-8">

        <meta http-equiv="X-UA-Compatible" content="IE=edge">

        <meta name="description" content="Invoice template">

        <meta name="keywords" content="invoice, receipt, bill">

        <meta name="author" content="initTheme">

        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Order</title>

        <link rel="stylesheet" type="text/css" href="pdfstyle/main-style.css">

        <style>

            body {

                background-color: #F9F9F9;

            }   



        </style>

          <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>

    <script>

    document.addEventListener("DOMContentLoaded", function() {

        document.getElementById("bill-download").addEventListener("click", function() {

            var element = document.getElementById("download-section");

            var opt = {

                margin: [0.5, 0.3, 0.5, 0.3],

                filename: "orders.pdf",

                image: { type: "jpeg", quality: 0.98 },

                html2canvas: { scale: 2 },

                jsPDF: { unit: "in", format: "letter", orientation: "portrait" }

            };

            html2pdf().from(element).set(opt).save();

        });

    });

    </script>

    </head>

    <body>

    <main class="container invoice-wrapper" id="download-section">

        <div class="invoice-top">

            <div class="row align-items-center">

                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-start mb-3 mb-sm-1">

                    <img src="' . htmlspecialchars(!empty($logopath) ? $logopath : 'logo/RF Ghee Logo Final .png') . '" alt="logo" width="130px">


                </div>

                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-end mb-3 mb-sm-1">

                    <h4 class="text-30 mb-0 mt-0">Order</h4>

                </div>

            </div>

            <hr>

            <div class="row">

                <div class="col-sm-6"><strong>Order Date:</strong> '. htmlspecialchars($orderdate) .'</div>

                <div class="col-sm-6 text-sm-end"><strong>Order No:</strong> '.$orderno.'</div>

            </div>

            <hr>

        </div>

        <div class="invoice-details border-top mt-20 pt-20">

            <div class="row">

                <div class="col-sm-6 text-sm-end order-sm-1">

                    <strong class="text-18 mb-3 d-inline-block">Pay To:</strong>

                    <address class="mb-4">

                        '. htmlspecialchars($profile['store_name']) . '<br>

                        '. htmlspecialchars($profile['street1']) .' '. htmlspecialchars($profile['street2']) .'<br>

                        ' . htmlspecialchars($profile['City']) . ' - '. htmlspecialchars($profile['Pincode']) .'<br>

                        '. htmlspecialchars($profile['phone']) .'

                    </address>

                </div>

                <div class="col-sm-6 order-sm-0">

                    <strong class="text-18 mb-3 d-inline-block">Ordered To:</strong>

                    <address class="mb-4">

                        '. htmlspecialchars($profile['displayname']).'<br>

                        '. htmlspecialchars($profile['address']).'<br>
                        '. htmlspecialchars($profile['address2']).'<br>

                        '. htmlspecialchars($profile['city']).' - '. htmlspecialchars($profile['pincode']).'<br>

                        '. htmlspecialchars($profile['phoneno']).'

                    </address>

                </div>

            </div>

        </div>

        <div class="card mb-3">

            <div class="card-body p-0">

                <div class="table-responsive">

                    <table class="table mb-0">

                        <thead class="card-header">

                            <tr>

                                <td class="col-3"><strong>Number</strong></td>

                                <td class="col-3"><strong>Product Name</strong></td>

                                <td class="col-4"><strong>Qty</strong></td>

                                <td class="col-2 text-center"><strong>MRP</strong></td>

                                <td class="col-1 text-center"><strong>Rate</strong></td>

                                <td class="col-2 text-end"><strong>Disc</strong></td>

                                <td class="col-2 text-end"><strong>Tax</strong></td>

                                <td class="col-2 text-end"><strong>Amount</strong></td>

                            </tr>

                        </thead>

                        <tbody>';

                        $count = 0;
                        $productsPerPage = 25;
                        
                        foreach ($order_data as $index => $item) {
                            $count++;
                        
                            $output .= '
                            <tr>
                                <td class="col-3">'.$count.'</td> 
                                <td class="col-3">'. htmlspecialchars($item['Product_name']) . '</td>  
                                <td class="col-4">'. $item['Qty'] . '</td>  
                                <td class="col-2 text-center">'. number_format($item['MRP'], 2) . '</td>  
                                <td class="col-1 text-center">' . htmlspecialchars($item['Selling_price']) . '</td>    
                                <td class="col-2 text-end">'. $item['Discount_percentage'] .'%</td>  
                                <td class="col-2 text-end">'. $item['Tax'].'</td>  
                                <td class="col-2 text-end">'. htmlspecialchars($item['Product_total']) .'</td>  
                            </tr>';
                        }
                            // Tax calculations for each product
                            $tax_percentage = $item['Tax_percentage'] ?? 0;
                            $tax_value = $item['Tax'] ?? 0;
                        
                            if ($tax_percentage > 0) {
                                $cgst = $tax_value / 2;
                                $sgst = $tax_value / 2;
                        
                                $output .= ' 
                                <tr>
                                    <td colspan="7" class="text-end"><strong>CGST @ ' . $tax_percentage / 2 . '% </strong></td>
                                    <td class="text-end">' . number_format($cgst, 2) . '</td>       
                                </tr>
                                <tr>
                                    <td colspan="7" class="text-end"><strong>SGST @ ' . $tax_percentage / 2 . '% </strong></td>
                                    <td class="text-end">' . number_format($sgst, 2) . '</td>       
                                </tr>';
                            }
                        
                            // Page break after every 25 products
                            if ($count % $productsPerPage == 0) {
                                $output .= '<tr><td colspan="8" style="page-break-before:always;"></td></tr>'; 
                            }
                        
                        
    $output .= '

        <tr>

            <td colspan="7" class="text-end"><strong>Total Savings:</strong></td>

            <td class="text-end"><strong>₹'. $totalSavings . '</strong></td>

        </tr>

        <tr>

            <td colspan="7" class="text-end"><strong>Grand Total:</strong></td>

            <td class="text-end"><strong>₹'.$grandtotal.'</strong></td>

        </tr>

        </tbody>

    </table>

    </div>

    </div>

    </div>

    <div class="text-center mt-5 mb-4 regular-button">

        <div class="d-print-none d-flex justify-content-center flex-wrap gap-10"> 

            <button id="bill-download" class="btn-primary-outline">Download</button> 

            <a href="javascript:window.print()" class="btn-primary-fill">Print Invoice</a> 

        </div>

    </div>

    </main>

    </body>

    </html>';



    $pdfContents[] = $output;




echo implode('<div style="page-break-after: always;"></div>', $pdfContents);

?>

