<?php 

session_start();

error_reporting(0);

include_once 'db.php';



$categoryid = $_POST['categoryid'];

$productstatusid = $_POST['productstatusid'];

$searchIconslist = trim($_POST['searchIcon']);

$stockstatusid = $_POST['stockstatusid'];

$searchIcons = strtolower($searchIconslist);

$sortby = $_POST['sortbyfiltrid'];  



$query = "SELECT p.*, i.productimg

FROM product p

LEFT JOIN (

    SELECT productid, productimg

    FROM (

        SELECT productid, productimg,

               ROW_NUMBER() OVER (PARTITION BY productid ORDER BY id) AS rn

        FROM productimg

    ) img

    WHERE rn = 1

) i ON p.id = i.productid

WHERE p.delete_status = '0' AND p.productname != ''";



// Filter by stock status

if ($stockstatusid != '') { 

    if ($stockstatusid == '1') {

        $query .= " AND p.qty <= 0";

    } elseif ($stockstatusid == '2') {

        $query .= " AND p.qty > 0";

    }

}



// Filter by product status

if ($productstatusid != '') { 

    $query .= " AND p.mode = '$productstatusid'";

}



// Filter by search term

if ($searchIcons != '') {

    $query .= " AND LOWER(p.productname) LIKE '%$searchIcons%'";

}



// Filter by category

if ($categoryid != '') {

    $query .= " AND p.category = '$categoryid'";

}



// Apply sorting

if ($sortby != '') {

    if ($sortby == '1') {

        $query .= " ORDER BY p.saleprice DESC";

    } elseif ($sortby == '2') {

        $query .= " ORDER BY p.saleprice ASC";

    } elseif ($sortby == '3') {

        $query .= " ORDER BY p.productname DESC";

    } elseif ($sortby == '4') {

        $query .= " ORDER BY p.qty DESC"; 

    } elseif ($sortby == '5') {

        $query .= " ORDER BY p.qty ASC"; 

    }

}



// Group by product ID

$query .= " GROUP BY p.id";  



$result = mysqli_query($connection, $query);

$numofrows = mysqli_num_rows($result);



$data = array();



if ($numofrows > 0) {

    while ($row = mysqli_fetch_array($result)) {

        $product_details = array(

            'id' => $row['id'],

            'productname' => $row['productname'],

            'sku' => $row['sku'],

            'saleprice' => $row['saleprice'],

            'mrp' => $row['mrp'],

            'qty' => $row['qty'] ?: '0', // Set default to 0 if qty is empty

            'productimg' => $row['productimg']

        );

        $data[] = $product_details;

    }

}



echo json_encode($data);

?>

