<?php
include_once 'db.php';

// Define the columns you want to include in the Excel export
$selectedColumns = array('Customer Name', 'Customer Mobile', 'Advance', 'GSTIN', 'Customer Status');

function filterData(&$str)
{
    $str = preg_replace("/\t/", "\\t", $str);
    $str = preg_replace("/\r?\n/", "\\n", $str);
    if (strstr($str, '"')) $str = '"' . str_replace('"', '""', $str) . '"';
}

// Define all possible fields
$fields = array('Customer Name', 'Customer Mobile', 'Advance', 'Due', 'GSTIN', 'Email', 'Tag', 'Type', 'Referral Code', 'Create Date', 'Customer Status');

// Ensure only selected fields are included
$selectedFields = array_flip(array_intersect($fields, $selectedColumns));

// Start the Excel data with headers
$excelData = implode("\t", $selectedColumns) . "\n";

$q = "SELECT id, displayname, phoneno, '' as balanceamount, gstno, email, customertype, 'Customer' as Customers, due, currentdate FROM customer WHERE delete_status=0";
$result = $connection->query($q);

// Fetch rows before looping
$rows = $result->fetch_all(MYSQLI_ASSOC);

foreach ($rows as $row) {
    $id = $row['id'];

    // Calculate $advance and $dues
    $sqlorder = "SELECT SUM(grandtotal) AS orderamount FROM orders WHERE customerid = '$id' AND delete_status='0' GROUP BY customerid";
    $resultorder = $connection->query($sqlorder);
    $rowsorder = mysqli_fetch_array($resultorder);
    $orderamount = $rowsorder['orderamount'] ?? 0;

    $sqlcustomer = "SELECT SUM(amount) AS totalamount FROM customerpayment WHERE customerid = '$id' GROUP BY customerid";
    $resultcustomer = $connection->query($sqlcustomer);
    $rowscustomer = mysqli_fetch_array($resultcustomer);
    $totalamount = $rowscustomer['totalamount'] ?? 0;

    $due = $orderamount - $totalamount;

    // Determine $advance and $dues
    if ($due < 0) {
        $advance = abs($due);
        $dues = '--';
    } else if ($due > 0) {
        $advance = '--';
        $dues = abs($due);
    } else {
        $advance = '--';
        $dues = '--';
    }

    // Determine Customer Status
    $customerStatus = ($advance !== '--') ? 'Advance' : (($dues !== '--') ? 'Due' : 'No Balance');

    $lineData = array(
        'Customer Name' => $row['displayname'],
        'Customer Mobile' => $row['phoneno'],
        'Advance' => $advance,
        'GSTIN' => $row['gstno'],
        'Customer Status' => $customerStatus,
    );

    // Debugging statement to print row data
    // print_r($lineData);

    // Select only the columns we need
    $selectedLineData = array_intersect_key($lineData, $selectedFields);
    array_walk($selectedLineData, 'filterData');
    $excelData .= implode("\t", array_values($selectedLineData)) . "\n";
}

// Output the Excel data for download
header("Content-Disposition: attachment; filename=\"customer_report.xls\"");
header("Content-Type: application/vnd.ms-excel");

// Output the formatted data
echo $excelData;
?>
