<?php
header('Content-Type: application/json');
require 'db.php'; // Assuming this contains the database connection

// Initialize response array
$response = array('status' => 'error', 'message' => 'Unknown error');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve and process the payload data
    $notes = isset($_POST['notes']) ? mysqli_real_escape_string($connection, $_POST['notes']) : '';
    $terms = isset($_POST['terms']) ? mysqli_real_escape_string($connection, $_POST['terms']) : '';
    
    // For the image
    $qrImagePath = ''; // Initialize image path variable
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $imageTmpName = $_FILES['image']['tmp_name'];
        $imageName = $_FILES['image']['name'];
        // Save the image to a specific path (e.g., 'uploads/')
        $qrImagePath = 'images/QR code/' . uniqid() . '-' . basename($imageName);
        move_uploaded_file($imageTmpName, $qrImagePath); // Save the image to the path
        $imageSize = filesize($imageTmpName);
    } else {
        $imageSize = 0;
    }

    // Update the database
    $sql = "UPDATE invoicesetting SET terms = '$terms', note = '$notes', qrcode = '$qrImagePath' WHERE id = 1";
    mysqli_query($connection, $sql);

    // Prepare success response with data
    $response['status'] = 'success';
    $response['message'] = 'Data received and processed successfully.';
    $response['data'] = array(
        'notes' => $notes,
        'terms' => $terms,
        'imageSize' => $imageSize
    );

} else {
    // Prepare error response
    $response['message'] = 'Invalid request method.';
}

// Output the JSON response
echo json_encode($response);
?>
