<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Search</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .customer-container {
            position: relative;
            width: 300px;
        }
        .customer-dropdown {
            display: none;
            position: absolute;
            width: 100%;
            background: white;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-shadow: 0px 2px 10px rgba(0, 0, 0, 0.1);
            margin-top: 5px;
            z-index: 10;
        }
        .customer-item {
            padding: 10px;
            cursor: pointer;
            display: flex;
            align-items: center;
        }
        .customer-item:hover {
            background: #e9f2ff;
        }
        .customer-icon {
            width: 30px;
            height: 30px;
            background: #ddd;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-right: 10px;
        }
        #customerInput {
            padding-right: 50px; /* Space for close button */
        }

        #closeDropdown {
            position: absolute;
            right: 10px;
            top: 70%;
            transform: translateY(-50%);
            cursor: pointer;
            color: blue;
            font-size: 14px;
            display: none;
        }
        .customer-add {
            font-weight: bold;
            color: blue;
        }
        .customer-price {
            margin-left: auto;
            font-weight: bold;
            color: black;
        }
        .guest-option {
            text-align: center;
            font-weight: bold;
            color: blue;
            padding: 10px;
            cursor: pointer;
        }
        .guest-option:hover {
            background: #f0f0f0;
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <div class="customer-container">
        <label for="customerInput" class="form-label">Customer</label>
        <div class="d-flex align-items-center">
            <input type="text" id="customerInput" class="form-control" placeholder="Enter Customer Name">
            <span class="close-btn ms-2" id="closeDropdown">CLOSE</span>
        </div>
        
        <div class="customer-dropdown" id="customerDropdown">
            <div class="customer-item bg-light">
                <div class="customer-icon">+</div>
                <span>Guest Customer</span>
                <span class="ms-auto customer-add">Add</span>
            </div>
            <div class="customer-item">
                <div class="customer-icon">G</div>
                <span>Guest Customer</span>
                <span class="customer-price">₹ 950</span>
            </div>
            <div class="customer-item">
                <div class="customer-icon">G</div>
                <span>Guest Customer</span>
            </div>
            <div class="guest-option">Use Guest Customer</div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $("#customerInput").on("input", function () {
            let inputVal = $(this).val().trim();
            if (inputVal.length > 0) {
                $("#customerDropdown, #closeDropdown").show();
            } else {
                $("#customerDropdown, #closeDropdown").hide();
            }
        });

        $("#closeDropdown").click(function () {
            $("#customerDropdown, #closeDropdown").hide();
            $("#customerInput").val("");
        });
    });
</script>

</body>
</html>
