document.addEventListener("DOMContentLoaded", function () {
    // Inject the bottom toolbar HTML
    const toolbarHTML = `
        <div class="offcanvas__stikcy--toolbar" tabindex="-1">
            <ul class="d-flex justify-content-around">
                <li class="offcanvas__stikcy--toolbar__list">
                    <a class="offcanvas__stikcy--toolbar__btn" data-page="dashborad.php" href="dashborad.php">
                        <span class="offcanvas__stikcy--toolbar__icon"> 
                            <i class="icon-copy dw dw-home"></i>
                        </span>
                        <span class="offcanvas__stikcy--toolbar__label">Home</span>
                    </a>
                </li>
                <li class="offcanvas__stikcy--toolbar__list">
                    <a class="offcanvas__stikcy--toolbar__btn" data-page="invoices.php" href="invoices.php">
                        <span class="offcanvas__stikcy--toolbar__icon"> 
                            <i class="micon dw dw-invoice"></i>
                        </span>
                        <span class="offcanvas__stikcy--toolbar__label">Invoice</span>
                    </a>
                </li>
                <li class="offcanvas__stikcy--toolbar__list">
                    <a class="offcanvas__stikcy--toolbar__btn" data-page="order.php" href="order.php">
                        <span class="offcanvas__stikcy--toolbar__icon"> 
                            <i class="icon-copy dw dw-shopping-bag"></i>
                        </span>
                        <span class="offcanvas__stikcy--toolbar__label">Orders</span>
                    </a>
                </li>
                <li class="offcanvas__stikcy--toolbar__list" style="width: 80px;">
    <a class="offcanvas__stikcy--toolbar__btn" data-page="catalogue.php" href="catalogue.php">
        <span class="offcanvas__stikcy--toolbar__icon">  
            <i class="icon-copy dw dw-package"></i>
        </span>
        <span class="offcanvas__stikcy--toolbar__label">Catalogue</span>
    </a>
</li>

                <li class="offcanvas__stikcy--toolbar__list">
                    <a class="offcanvas__stikcy--toolbar__btn" data-page="manage.php" href="manage.php">
                        <span class="offcanvas__stikcy--toolbar__icon"> 
                            <i class="icon-copy ti-layout-grid2"></i>
                        </span>
                        <span class="offcanvas__stikcy--toolbar__label">Manage</span>
                    </a>
                </li>
            </ul>
        </div>
    `;

    // Append the toolbar to the body
    document.body.insertAdjacentHTML('beforeend', toolbarHTML);

    // Select all bottom toolbar links
    const toolbarLinks = document.querySelectorAll(".offcanvas__stikcy--toolbar__btn");

    // Get the current page from the URL (without query parameters)
    let currentPage = window.location.pathname.split("/").pop();

    // **🔹 If coming from login, force dashborad active**
    if (currentPage === "dashborad.php" || currentPage === "") {
        localStorage.setItem("activeToolbar", "dashborad.php");
    }

    // Retrieve the active toolbar link from localStorage or use the current page
    let activePage = localStorage.getItem("activeToolbar") || currentPage;

    // Function to update active link
    function setActiveToolbar(activeURL) {
        toolbarLinks.forEach(link => {
            if (link.getAttribute("data-page") === activeURL) {
                link.classList.add("active");
            } else {
                link.classList.remove("active");
            }
        });
    }

    // Apply active state based on stored or current URL
    setActiveToolbar(activePage);

    // Handle clicks on bottom nav links
    toolbarLinks.forEach(link => {
        link.addEventListener("click", function () {
            let page = this.getAttribute("data-page");
            localStorage.setItem("activeToolbar", page);
            setActiveToolbar(page);
        });
    });

    // Handle dashborad link clicks to update bottom nav
    document.querySelectorAll("a").forEach(link => {
        link.addEventListener("click", function () {
            let page = this.getAttribute("href").split("/").pop();
            if (page) {
                localStorage.setItem("activeToolbar", page);
                setActiveToolbar(page);
            }
        });
    });
});
