<?php
// $id=$_GET["id"];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wishlist</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
	<!-- CSS -->


<link rel="stylesheet" type="text/css" href="vendors/styles/core.css">
	<link rel="stylesheet" type="text/css" href="vendors/styles/icon-font.min.css">
	<link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/dataTables.bootstrap4.min.css">
	<link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/responsive.bootstrap4.min.css">
	
		<link rel="stylesheet" type="text/css" href="vendors/styles/style.css">  

    <style>
        body {
            background-color: #fff;
        }
        .container {
            background: #fff;
            position: fixed;
            padding: 10px;
            margin-top: 0;
            margin-left: 0;
            margin-right: 0;
        }
        .header1 {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 48px;
        }
        .header1 .icons i {
            font-size: 20px;
            cursor: pointer;
        }
        
        .header1 div span {
            font-size: 17px;
            color: #000;
            font-weight: 500;
        }

        .wishlist-container {
            width: 100%;
            border-radius: 10px;
            padding-top: 60px;
        }

        .back-btn {
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
        }

        .tabs {
            background-color: #fff;
            display: flex;
            justify-content: space-around;
            border-bottom: 1px solid #D9D9D9;
        }

        .tab {
            padding: 10px;
            cursor: pointer;
            background: none;
            border: none;
            font-size: 16px;
            font-weight: 500;
            color: #6578B3;
        }

        .tab.active {
            border-bottom: 2px solid blue;
            color: #253ED6;
        }

        .tab-content {
            display: none;
            padding: 10px;
        }

        .tab-content.active {
            display: block;
        }

        .product-item, .customer-item {
            display: flex;
            align-items: center;
            background: #fff;
            padding: 10px;
            margin: 10px 0;
            border-radius: 8px;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
        }

        .image-placeholder, .customer-icon {
            width: 70px;
            height: 70px;
            background: #D9D9D9;
            border-radius: 5px;
            margin-right: 10px;
        }

        .customer-icon {
            width: 45px;
            height: 45px;
            background: #D9D9D9;
            border-radius: 50%;
            margin-right: 10px;
            display: flex;
            align-items: center;
            text-align: center;
            justify-content: center;
        }


        .product-info {
            flex-grow: 1;
            width: 55%;
        }

        .customer-info {
            width: 65%;
        }

        .product-info h3,
        .customer-info h3 {
            font-size: 16px;
            font-weight: 500;
            color: #000;
            margin-bottom: 8px;
        }

        .product-info p {
            font-size: 14px;
            font-weight: 500;
            color: #565656;
        }

        
        .customer-info p {
            font-size: 12px;
            font-weight: 500;
            color: #565656;
        }

        .customers, .products {
            font-weight: 500;
            color: #253ED6;
            text-align: center;
            font-size: 20px;
        }

        .customers span,
        .products span {
            font-size: 14px;
            font-weight: 500;
            color: #565656;
        }

        .modal.fade .modal-dialog {
            position: absolute;
            bottom: 0;
            margin: 0;
            width: 100%;
            transform: translateY(100%); /* Starts off-screen */
            transition: transform 0.4s ease-out;
        }

        .modal.show .modal-dialog {
            transform: translateY(0); /* Slides up */
        }

        .modal-title {
            font-size: 20px;
            font-weight: 500;
            color: #000;
        }

        .modal-header {
            border-bottom: none;
        }

        .modal-content {
            border-radius: 20px 20px 0px 0px;
            border: none;
        }

        .modal-body {
            height: 500px;
        }

        .modal-body p {
            font-weight: 500;
        }


        @media (max-width: 480px) {
            body, h1, h2, h3, h4, h5, h6, .h4, .h5, .page-header h4 {
                font-family: "Noto Sans Devanagari", serif !important;
                font-weight: normal ;
            }
        }
    </style>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Aldrich&family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Noto+Sans+Devanagari:wght@100..900&family=Noto+Sans:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

</head>
<body>

    <div class="container">
        <!-- Header1 Section -->
        <div class="header1">
            <div class="d-flex">
                <a href="dashborad.php"><i class="fas fa-arrow-left" style="font-size: 24px;"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;<span>Wishlist </span>
            </div>
        </div>
    </div>

    <div class="wishlist-container">
        <div class="tabs">
            <button class="tab active" data-tab="product">By Product</button>
            <button class="tab" data-tab="customer">By Customer</button>
        </div>
        <div class="tab-content active" id="product">
            <div calss="productlist" id="productList"></div>
            <!-- <div class="product-item" data-bs-toggle="modal" data-bs-target="#wishedByModal">
                <div class="image-placeholder"></div>
                <div class="product-info">
                    <h3>Organic Coconut Oil / Organic Coconut Oil</h3>
                    <p>Cooking Oils & Ghee</p>
                </div>
                <div class="customers">3 <span>Customers</span></div>
            </div>
            <div class="product-item">
                <div class="image-placeholder"></div>
                <div class="product-info">
                    <h3>Organic Coconut Oil / Organic Coconut Oil</h3>
                    <p>Cooking Oils & Ghee</p>
                </div>
                <div class="customers">3 <span>Customers</span></div> -->
            </div>
        </div>
        <div class="tab-content" id="customer">
            <div class="customer" id="customerList"></div>
             <!-- <div class="customer-item" data-bs-toggle="modal" data-bs-target="#productListModal">
                <div class="customer-icon">
                    <img src="images/iconamoon_profile-light.png" alt="">
                </div>
              
                <div class="customer-info">
                    <h3>Harikumar</h3>
                    <p class="d-flex align-items-center"><img src="images/f7_phone-circle (1).png" alt="">&nbsp; 9443495090</p>
                </div>
                <div class="products">4 <span>Products</span></div>
            </div>
            <div class="customer-item">
                <div class="customer-icon">
                    <img src="images/iconamoon_profile-light.png" alt="">
                </div>
                <div class="customer-info">
                    <h3>Harikumar</h3>
                    <p class="d-flex align-items-center"><img src="images/f7_phone-circle (1).png" alt="">&nbsp; 9443495090</p>
                </div>
                <div class="products">4 <span>Products</span></div>
            </div> -->
        </div>
    </div>



    <!-- Wished By Modal -->
    <div class="modal fade" id="wishedByModal" tabindex="-1" aria-labelledby="wishedByLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="wishedByLabel">Wished By</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="customergroup" id="customerlistmodal"></div>
                    <!-- <div class="d-flex align-items-center mb-2">
                        <div class="customer-icon" style="">
                            <img src="images/iconamoon_profile-light.png" alt="">
                        </div>
                        <div class="customer-info">
                            <h3>Harikumar</h3>
                            <p class="d-flex align-items-center"><img src="images/f7_phone-circle (1).png" alt="">&nbsp; 9443495090</p>
                        </div>
                    </div>
                    <hr style="border: 1px solid #9D9D9D">
                    <div class="d-flex align-items-center">
                        <div class="customer-icon" style="">
                            <img src="images/iconamoon_profile-light.png" alt="">
                        </div>
                        <div class="customer-info">
                            <h3>Harikumar</h3>
                            <p class="d-flex align-items-center"><img src="images/f7_phone-circle (1).png" alt="">&nbsp; 9443495090</p>
                        </div>
                    </div>
                    <hr style="border: 1px solid #9D9D9D"> -->
                </div>
            </div>
        </div>
    </div>


<!-- Harikumar’s Product List Modal -->
<div class="modal fade" id="productListModal" tabindex="-1" aria-labelledby="productListLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="productListLabel">Product List</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="productgroup"></div>
            </div>
        </div>
    </div>
</div>


    <!-- Harikumar’s Product List Modal -->
    <!-- <div class="modal fade" id="productListModal" tabindex="-1" aria-labelledby="productListLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="productListLabel">Harikumar’s Product List</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                <div class="productgroup"></div>
                    <div class="d-flex align-items-center mb-2">
                        <div class="customer-icon" style="width: 38px; height: 38px; border-radius: 10px;"></div>
                        <p class="mb-0">Moong Daal / Paasi Paruppu - 250 Gm</p>
                    </div>
                    <hr style="border: 1px solid #9D9D9D">
                    <div class="d-flex align-items-center mb-2">
                        <div class="customer-icon" style="width: 38px; height: 38px; border-radius: 10px;"></div>
                        <p class="mb-0">Moong Daal / Paasi Paruppu - 250 Gm</p>
                    </div>
                    <hr style="border: 1px solid #9D9D9D">
                    <div class="d-flex align-items-center mb-2">
                        <div class="customer-icon" style="width: 38px; height: 38px; border-radius: 10px;"></div>
                        <p class="mb-0">Moong Daal / Paasi Paruppu - 250 Gm</p>
                    </div>
                    <hr style="border: 1px solid #9D9D9D">
                    <div class="d-flex align-items-center">
                        <div class="customer-icon" style="width: 38px; height: 38px; border-radius: 10px;"></div>
                        <p class="mb-0">Moong Daal / Paasi Paruppu - 250 Gm</p>
                    </div>
                    <hr style="border: 1px solid #9D9D9D">
                </div>
            </div>
        </div>
    </div>
 -->

	
	<script src="vendors/scripts/core.js"></script>
	<script src="vendors/scripts/script.min.js"></script>
	<script src="vendors/scripts/process.js"></script>
	<script src="vendors/scripts/layout-settings.js"></script>
	<script src="src/plugins/datatables/js/jquery.dataTables.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.responsive.min.js"></script>
	<script src="src/plugins/datatables/js/responsive.bootstrap4.min.js"></script>
	<!-- buttons for Export datatable -->
	<script src="src/plugins/datatables/js/dataTables.buttons.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.print.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.html5.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.flash.min.js"></script>
	<script src="src/plugins/datatables/js/pdfmake.min.js"></script>
	<script src="src/plugins/datatables/js/vfs_fonts.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const tabs = document.querySelectorAll(".tab");
            const contents = document.querySelectorAll(".tab-content");

            tabs.forEach(tab => {
                tab.addEventListener("click", function() {
                    tabs.forEach(t => t.classList.remove("active"));
                    contents.forEach(c => c.classList.remove("active"));

                    tab.classList.add("active");
                    document.getElementById(tab.dataset.tab).classList.add("active");
                });
            });
        });
    </script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    // Fetch customer list from API
    fetch("https://hapitest.xyz/hapi%20commers/api/wishlistlistbycustomerid-api.php")
        .then(response => response.json())
        .then(data => {
            if (data.status === "success") {
                populateCustomerList(data.data);
            } else {
                console.error("Error fetching data:", data.message);
            }
        })
        .catch(error => console.error("Error:", error));
});

// Function to populate customer list UI
function populateCustomerList(customers) {
    const customerContainer = document.getElementById("customerList");
    if (!customerContainer) {
        console.error("Error: #customerList not found in the DOM");
        return;
    }

    customerContainer.innerHTML = ""; // Clear previous list

    customers.forEach(customer => {
        const customerDiv = document.createElement("div");
        customerDiv.innerHTML = `
            <div class="customer-item" data-customerid="${customer.customer_id}">
                <div class="customer-icon">
                    <img src="images/iconamoon_profile-light.png" alt="">
                </div>
                <div class="customer-info">
                    <h3>${customer.customer_name}</h3>
                    <p class="d-flex align-items-center"><img src="images/f7_phone-circle (1).png" alt="">&nbsp; ${customer.phone}</p>
                </div>
                <div class="products">
                    ${customer.product_count}<span> Products</span>
                </div>
            </div>
        `;

        // Attach click event to the entire customer item
        customerDiv.querySelector(".customer-item").addEventListener("click", function () {
            const customerId = this.getAttribute("data-customerid");
            console.log("Fetching wishlist for customer_id:", customerId); // Debugging
            fetchWishlist(customerId);
        });

        customerContainer.appendChild(customerDiv);
    });
}

// Function to fetch wishlist for a specific customer
function fetchWishlist(customerId) {
    fetch(`https://hapitest.xyz/hapi%20commers/api/getwishlistbyuser-api.php?customer_id=${customerId}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === "success") {
                showModal(customerId, data.data);
            } else {
                console.error("Error fetching wishlist:", data.message);
            }
        })
        .catch(error => console.error("Error:", error));
}

// Function to show wishlist modal
function showModal(customerId, wishlist) {
    console.log("Wishlist data received:", wishlist); // Debugging

    const modalTitle = document.getElementById("productListLabel");
    if (!modalTitle) {
        console.error("Error: #productListLabel not found in the DOM");
        return;
    }
    modalTitle.textContent = `Wishlist Items`;

    const modalBody = document.querySelector("#productListModal .modal-body .productgroup");
    if (!modalBody) {
        console.error("Error: .productgroup not found inside modal");
        return;
    }

    modalBody.innerHTML = ""; // Clear previous content

    if (wishlist && wishlist.length > 0) {
        wishlist.forEach((product, index) => {
            console.log("Adding wishlist product:", product.product_name); // Debugging

            const productDiv = document.createElement("div");
            productDiv.classList.add("d-flex", "align-items-center", "mb-2");
            productDiv.innerHTML = `
                <div class="customer-icon" style="width: 38px; height: 38px; border-radius: 10px;"> <img style="height: 100%;" src="${decodeURIComponent(product.Product_image)}" alt=""></div>
                <p class="mb-0">${product.product_name}</p>
            `;
            modalBody.appendChild(productDiv);

            // Add a separator after each product (except last one)
            if (index < wishlist.length - 1) {
                const separator = document.createElement("hr");
                separator.style.border = "1px solid #9D9D9D";
                modalBody.appendChild(separator);
            }
        });
    } else {
        console.warn("No wishlist products found for customer_id:", customerId);
        modalBody.innerHTML = `<p class="text-center">No wishlist items available</p>`;
    }

    // Show modal
    const modal = new bootstrap.Modal(document.getElementById("productListModal"));
    modal.show();
}
</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
    console.log("Page Loaded: Fetching product list...");

    // Fetch product list from API
    fetch("https://hapitest.xyz/hapi%20commers/api/getwishlistlistbyproduct-api.php") // Replace with your API endpoint
        .then(response => response.json())
        .then(data => {
            console.log("Product Wishlist API Response:", data);

            if (data.status === "success") {
                populateProductList(data.data);
            } else {
                console.error("Error fetching data:", data.message);
            }
        })
        .catch(error => console.error("Error:", error));
});

// Function to populate product list UI
function populateProductList(products) {
    const productContainer = document.getElementById("productList");

    if (!productContainer) {
        console.error("Error: #productList not found in the DOM");
        return;
    }

    productContainer.innerHTML = ""; // Clear previous list

    products.forEach(product => {
        const productDiv = document.createElement("div");
        productDiv.classList.add("product-item");
        productDiv.setAttribute("data-bs-toggle", "modal");
        productDiv.setAttribute("data-bs-target", "#wishedByModal");
        productDiv.setAttribute("data-product-id", product.product_id);
        productDiv.innerHTML = `
            <div class="image-placeholder">
             <img style="height: 100% !important;" src="${decodeURIComponent(product.product_image)}" alt=""></div>
            <div class="product-info">
                <h3>${product.product_name}</h3>
                <p>Wishlist Count: ${product.wishlist_count}</p>
            </div>
            <div class="customers">${product.customer_count} <span>Customers</span></div>
        `;

        productContainer.appendChild(productDiv);
    });

    // Attach event listener for modal opening
    const modal = document.getElementById("wishedByModal");
    modal.addEventListener("show.bs.modal", function (event) {
        const button = event.relatedTarget; // Element that triggered the modal
        const productId = button.getAttribute("data-product-id");

        console.log(`Opening modal for Product ID: ${productId}`);
        fetchCustomers(productId);
    });
}

// Function to fetch customers who wishlisted the product
function fetchCustomers(productId) {
    console.log("Fetching customers for Product ID:", productId);

    fetch(`https://hapitest.xyz/hapi%20commers/api/getwishlistbyproduct-api.php?product_id=${productId}`) // Replace with your API
        .then(response => response.json())
        .then(data => {
            console.log("Wishlist Customers API Response:", data);

            if (data.status === "success") {
                updateModal(data.data);
            } else {
                console.warn("No customers found for product ID:", productId);
                updateModal([]);
            }
        })
        .catch(error => console.error("Error fetching customers:", error));
}

// Function to update modal with customer data
// Function to update modal with customer data
function updateModal(customers) {
    console.log("Updating modal with customer data");

    const modalBody = document.querySelector("#customerlistmodal"); // Corrected to target your div

    if (!modalBody) {
        console.error("Error: Customer list container not found in the DOM");
        return;
    }

    modalBody.innerHTML = ""; // Clear previous content

    if (customers.length > 0) {
        customers.forEach((customer, index) => {
            const customerDiv = document.createElement("div");
            customerDiv.classList.add("d-flex", "align-items-center", "mb-2");
            customerDiv.innerHTML = `
            <div class="customer-icon" style="">
                            <img src="images/iconamoon_profile-light.png" alt="">
                        </div>
                <div class="customer-info">
                    <h3>${customer.customer_name}</h3>
                    <p class="d-flex align-items-center"><img src="images/f7_phone-circle (1).png" alt="">&nbsp; ${customer.phoneno}</p>
                </div>
            `;
            modalBody.appendChild(customerDiv);

            // Add a separator after each customer (except last one)
            if (index < customers.length - 1) {
                const separator = document.createElement("hr");
                separator.style.border = "1px solid #9D9D9D";
                modalBody.appendChild(separator);
            }
        });
    } else {
        modalBody.innerHTML = `<p class="text-center">No customers available</p>`;
    }
}


</script>
</body>
</html>
