<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db.php'; // Include your database connection

$response = ["status" => "error", "message" => "Invalid Request"];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Get JSON input
    $data = json_decode(file_get_contents("php://input"), true);

    if (!empty($data['customerid']) && !empty($data['customername']) && !empty($data['phonenumber']) &&
        !empty($data['address']) && !empty($data['city']) && !empty($data['state']) && !empty($data['pincode'])) {
        
        $customerid = intval($data['customerid']);
        $customername = mysqli_real_escape_string($conn, $data['customername']);
        $phonenumber = mysqli_real_escape_string($conn, $data['phonenumber']);
        $address = mysqli_real_escape_string($conn, $data['address']);
        $city = mysqli_real_escape_string($conn, $data['city']);
        $state = mysqli_real_escape_string($conn, $data['state']);
        $pincode = mysqli_real_escape_string($conn, $data['pincode']);

        if (!empty($data['addressid'])) {
            // If addressid is provided, update the existing record
            $addressid = intval($data['addressid']);
            $query = "UPDATE address SET 
                        customerid = '$customerid',
                        customername = '$customername',
                        phonenumber = '$phonenumber',
                        address = '$address',
                        city = '$city',
                        state = '$state',
                        pincode = '$pincode'
                      WHERE addressid = $addressid";

            if (mysqli_query($conn, $query)) {
                $response = ["status" => "success", "message" => "Address updated successfully"];
            } else {
                $response = ["status" => "error", "message" => "Failed to update address: " . mysqli_error($conn)];
            }
        } else {
            // If no addressid, insert a new record
            $query = "INSERT INTO address (customerid, customername, phonenumber, address, city, state, pincode) 
                      VALUES ('$customerid', '$customername', '$phonenumber', '$address', '$city', '$state', '$pincode')";

            if (mysqli_query($conn, $query)) {
                $response = ["status" => "success", "message" => "Address inserted successfully"];
            } else {
                $response = ["status" => "error", "message" => "Failed to insert address: " . mysqli_error($conn)];
            }
        }
    } else {
        $response = ["status" => "error", "message" => "Missing required fields"];
    }
}

echo json_encode($response);
?>
