<?php
session_start();
include 'db.php';

$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.'
    ]);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Malformed JSON input.'
    ]);
    exit;
}

if (empty($data['Products']) || !isset($data['Shipping'], $data['Roundoff'], $data['Discount_percentage'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid input data.'
    ]);
    exit;
}

$customerid = $data['customerid'];
$shipping = (float)($data['Shipping'] ?? 0);
$roundoff = (float)($data['Roundoff'] ?? 0);
$tax_percentage = (float)($data['tax_percentage'] ?? 0);
$discount_percentage = (float)($data['Discount_percentage'] ?? 0);
$products = $data['Products'];
$created_date = $data['invoicedate'];

$product_total = $tax_total = $discount_total = $total_savings = 0;

// Validate customer
$user_query = "SELECT displayname FROM customer WHERE id= '$customerid' AND delete_status = 0";
$user_result = mysqli_query($conn, $user_query);

if (!$user_result || mysqli_num_rows($user_result) == 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Customer not found or inactive.'
    ]);
    exit;
}

$user_data = mysqli_fetch_assoc($user_result);
$displayname = $user_data['displayname'];

// Generate estimate number
$query = "SELECT Estimate_no FROM estimate ORDER BY estimate_id DESC LIMIT 1";
$result = mysqli_query($conn, $query);
$formatted_number = ($result && mysqli_num_rows($result) > 0)
    ? str_pad((int)substr(mysqli_fetch_assoc($result)['Estimate_no'], 4) + 1, 4, '0', STR_PAD_LEFT)
    : "0001";
$estimate_no = "EST-" . $formatted_number;

// Process each product
foreach ($products as $product) {
    if (!isset($product['Product_id'], $product['Selling_price'], $product['Tax_percentage'], $product['Qty'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid product data.'
        ]);
        exit;
    }

    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];

    $product_query = "SELECT Product_name, MRP, qty, sale_price_tax  FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result = mysqli_query($conn, $product_query);

    if (!$product_result || mysqli_num_rows($product_result) == 0) {
        echo json_encode([
            'status' => 'error',
            'message' => "Product ID $product_id not found or inactive."
        ]);
        exit;
    }

    $product_data = mysqli_fetch_assoc($product_result);
    if ($product_data['qty'] < $qty) {
        echo json_encode([
            'status' => 'error',
            'message' => "Insufficient stock for Product ID $product_id."
        ]);
        exit;
    }
    
$mrp = (float)$product_data['MRP'];
$sale_price_tax = (int)$product_data['sale_price_tax'];

// Calculate values
$discount = ($selling_price * $discount_percentage) / 100;
$product_subtotal = $selling_price * $qty;
$tax = 0;

if ($sale_price_tax == 2) {
    // Only calculate tax if sale_price_tax is 2
    $tax = ($product_subtotal * $tax_percentage) / 100;
}

$product_total += $product_subtotal;
$tax_total += $tax;
$discount_total += $discount * $qty;
$total_savings += ($mrp - $selling_price) * $qty;
}

$grand_total = $product_total + $tax_total + $shipping - $roundoff;
$grand_total1 = number_format((float)$grand_total, 2, '.', '');


// Insert into estimate table
$estimate_query = "
    INSERT INTO estimate (
        Estimate_no, user_id, displayname, Created_date, Tax, Tax_percentage, Discount, Discount_percentage,
        Shipping, Roundoff, Total_saving, Total_price, No_of_items, Total_discount, Grand_total, 
        Created_id, Editor_id, Delete_status
    ) VALUES (
        '$estimate_no', '$customerid', '$displayname', '$created_date', '$total_tax', '$tax_percentage', '$total_discount', 
        '$discount_percentage', '$shipping', '$roundoff', '$total_saving', '$total_price', 
        '".count($products)."', '$total_discount', '$grand_total1', '$user_id', '$user_id', 0
    )
";

if (!mysqli_query($conn, $estimate_query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to create estimate.',
        'error' => mysqli_error($conn)
    ]);
    exit;
}

$estimate_id = mysqli_insert_id($conn);

// Insert into estimate_data table
foreach ($products as $product) {
    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $product_query2 = "SELECT MRP, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result2 = mysqli_query($conn, $product_query2);

    $product_data2 = mysqli_fetch_assoc($product_result2);

    $selling_price = (float)$product['Selling_price'];
    $qty = (int)$product['Qty'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $discount_percentage1 = (float)$product['discount_Percentage'];
    $MRP = (float)$product_data2['MRP'];
    $Sale_Price_Tax = $product_data2['sale_price_tax'];

    $discount = ($selling_price * $discount_percentage1) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = ($product_subtotal * $tax_percentage) / 100;

    $estimate_data_query = "
        INSERT INTO estimate_data (
            estimate_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
            Tax_percentage, Tax, Product_total, Delete_status, salepricetax
        ) VALUES (
            '$estimate_id', '$product_id', '$qty', '$selling_price', '$MRP', '$discount', 
            '$discount_percentage1', '$tax_percentage', '$tax', '$product_subtotal', 0, '$Sale_Price_Tax'
        )
    ";
    mysqli_query($conn, $estimate_data_query);
}

echo json_encode([
    "status" => "success",
    "message" => "Estimate created successfully",
    "estimate_id" => $estimate_id
]);
?>