<?php
session_start();

include('db.php'); // Include database connection

// Check if the user is logged in
$user_id = $_SESSION['user_id'] ?? null;
if (!$user_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.'
    ]);
    exit;
}

// Get JSON data
$data = json_decode(file_get_contents('php://input'), true);

// Validate input data
if (empty($data['Products']) || !isset($data['Shipping'], $data['Roundoff'], $data['Discount_percentage'], $data['Balance'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid input data.'
    ]);
    exit;
}

// Assign input data to variables
$customerid = $data['customerid'];
$paymentid = $data['paymentid'];
$shipping = (float)($data['Shipping'] ?? 0);
$roundoff = (float)($data['Roundoff'] ?? 0);
$discount_percentage = (float)$data['Discount_percentage'];
$balance = (float)$data['Balance'];
$products = $data['Products'];

$product_total = $tax_total = $discount_total = $total_savings = 0;

// Validate customer
$user_query = "SELECT displayname FROM customer WHERE id= '$customerid' AND delete_status = 0";
$user_result = mysqli_query($conn, $user_query);

if (!$user_result || mysqli_num_rows($user_result) == 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Customer not found or inactive.'
    ]);
    exit;
}

$user_data = mysqli_fetch_assoc($user_result);
$displayname = $user_data['displayname'];

// Process each product
foreach ($products as $product) {
    if (!isset($product['Product_id'], $product['Selling_price'], $product['Tax_percentage'], $product['Qty'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid product data.'
        ]);
        exit;
    }

    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];

       // Fetch product details
$product_query = "SELECT Product_name, MRP, qty, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
$product_result = mysqli_query($conn, $product_query);

if (mysqli_num_rows($product_result) == 0) {
    echo json_encode([
        'status' => 'error',
        'message' => "Product ID $product_id not found or inactive."
    ]);
    exit;
}

$product_data = mysqli_fetch_assoc($product_result);
if ($product_data['qty'] < $qty) {
    echo json_encode([
        'status' => 'error',
        'message' => "Insufficient stock for Product ID $product_id."
    ]);
    exit;
}

$mrp = (float)$product_data['MRP'];
$sale_price_tax = (int)$product_data['sale_price_tax']; // Get sale price tax value (1 or 2)

// Calculate values
$discount = ($selling_price * $discount_percentage) / 100;
$product_subtotal = $selling_price * $qty;
$tax = 0;

if ($sale_price_tax == 2) {
    // Only calculate tax if sale_price_tax is 2
    $tax = ($product_subtotal * $tax_percentage) / 100;
}

$product_total += $product_subtotal;
$tax_total += $tax;
$discount_total += $discount * $qty;
$total_savings += ($mrp - $selling_price) * $qty;
}

$grand_total = $product_total + $tax_total + $shipping - $roundoff;
$grand_total1 = number_format((float)$grand_total, 2, '.', '');



// Insert into `purchase`
$created_date = date('Y-m-d H:i:s');
$due_date = $data['duedate'];
$payment_status = ($balance == 0) ? 1 : (($balance < $grand_total) ? 2 : 0);

$purchase_query = "
    INSERT INTO purchase (
        vendor_id, displayname, Created_date, Due_date, Balance, 
        Tax, Tax_percentage, Discount, Discount_percentage, Shipping, Roundoff, 
        Total_price, Grand_total, No_of_items, Created_id, Editor_id, 
        Delete_status, Total_saving, Total_discount, Payment_status, Action_status,
        Payment_id
    ) VALUES (
        '$customerid', '$displayname', '$created_date', '$due_date', '$balance',
        '$tax_total', '$tax_percentage','$discount_total', '$discount_percentage', '$shipping', '$roundoff',
        '$product_total', '$grand_total1', '" . count($products) . "',
        '$user_id', '$user_id', 0, '$total_savings', '$discount_total',
        '$payment_status', 1, '$paymentid'
    )";
if (!mysqli_query($conn, $purchase_query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to create purchase.',
        'error' => mysqli_error($conn)
    ]);
    exit;
}

$purchase_id = mysqli_insert_id($conn);
$formatted_purchase_no = 'PUH-' . str_pad($purchase_id, 4, '0', STR_PAD_LEFT);
mysqli_query($conn, "UPDATE purchase SET purchase_no = '$formatted_purchase_no' WHERE purchase_id = '$purchase_id'");

// Insert products into `purchase_data`
foreach ($products as $product) {
    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    
    $product_query2 = "SELECT  MRP,  sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
$product_result2 = mysqli_query($conn, $product_query2);

$product_data2 = mysqli_fetch_assoc($product_result2);

    $selling_price = (float)$product['Selling_price'];
    $MRP = (float)$product_data2['MRP'];
    $Sale_Price_Tax= $product_data2['sale_price_tax'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];
    $discount_percentage1 = (float)$product['discount_Percentage'];

    $discount = ($selling_price * $discount_percentage1) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = ($product_subtotal * $tax_percentage) / 100;

    $purchase_data_query = "
        INSERT INTO purchase_data (
            purchase_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
            Tax_percentage, Tax, Product_total, Delete_status,salepricetax
        ) VALUES (
            '$purchase_id', '$product_id', '$qty', '$selling_price', '$MRP', '$discount', 
            '$discount_percentage1', '$tax_percentage', '$tax', '$product_subtotal', 0,'$Sale_Price_Tax'
        )";

    mysqli_query($conn, $purchase_data_query);

  
}

// Return success response
echo json_encode([
    'status' => 'success',
    'message' => 'Order and purchase created successfully.',
    'purchase_id' => $purchase_id,
    'purchase_no' => $formatted_purchase_no,
    'grand_total' => $grand_total
]);
?>
