<?php
include("db.php");

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    if (!isset($data['categoryid']) || !isset($data['name']) || !isset($data['image'])) {
        echo json_encode(['status' => 'error', 'message' => 'Required fields are missing']);
        exit();
    }

    $id = isset($data['id']) ? $conn->real_escape_string($data['id']) : null;
    $categoryID = $conn->real_escape_string($data['categoryid']);
    $subcategory_name = $conn->real_escape_string($data['name']);
    $image = isset($data['image']) ? $conn->real_escape_string($data['image']) : null;
    $urlslug = $conn->real_escape_string($data['urlslug']);
    $gmccategorg = $conn->real_escape_string($data['gmccategory']);
    $seotitle = $conn->real_escape_string($data['seotitle']);
    $seodescription = $conn->real_escape_string($data['description']);
    $createdAt = date('Y-m-d H:i:s');
    $deleteStatus = 0;

    if ($id) {
        // Prepare SQL update query
        if ($image) {
            // Update image only if it's provided
            $sql = "UPDATE subcategory 
                    SET 
                        Category_ID = '$categoryID', 
                        Subcategory_Name = '$subcategory_name', 
                        image = '$image', 
                        gmccategorg = '$gmccategorg', 
                        urlslug = '$urlslug', 
                        seotitle = '$seotitle', 
                        seodescription = '$seodescription', 
                        Delete_status = '$deleteStatus' 
                    WHERE ID = '$id'";
        } else {
            // Update without changing image if image is not provided
            $sql = "UPDATE subcategory 
                    SET 
                        Category_ID = '$categoryID', 
                        Subcategory_Name = '$subcategory_name', 
                        gmccategorg = '$gmccategorg', 
                        urlslug = '$urlslug', 
                        seotitle = '$seotitle', 
                        seodescription = '$seodescription', 
                        Delete_status = '$deleteStatus' 
                    WHERE ID = '$id'";
        }

        if ($conn->query($sql) === TRUE) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Category updated successfully',
                'data' => [
                    'id' => $id,
                    'category_ID' => $categoryID, 
                    'subcategory_name' => $subcategory_name,
                    'image' => $image,
                    'urlslug' => $urlslug,
                    'gmccategorg' => $gmccategorg,
                    'seotitle' => $seotitle,
                    'seodescription' => $seodescription,
                    'Delete_status' => $deleteStatus
                ]
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update category', 'error_detail' => $conn->error]);
        }
    } else {
        // Perform insert
        $sql = "INSERT INTO subcategory (Category_ID, Subcategory_Name, image, gmccategorg, urlslug, seotitle, seodescription, Created_At, Delete_status) 
                VALUES ('$categoryID', '$subcategory_name', '$image', '$gmccategorg', '$urlslug', '$seotitle', '$seodescription', '$createdAt', '$deleteStatus')";

        if ($conn->query($sql) === TRUE) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Category added successfully',
                'data' => [
                    'id' => $conn->insert_id,
                    'category_ID' => $categoryID, 
                    'subcategory_name' => $subcategory_name,
                    'image' => $image,
                    'Create_at' => $createdAt,
                    'Delete_status' => $deleteStatus
                ]
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert category', 'error_detail' => $conn->error]);
        }
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
