<?php
session_start();

include('db.php');

$user_id = $_SESSION['user_id'] ?? null;

if (!$user_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.'
    ]);
    exit;
}

$contentType = $_SERVER["CONTENT_TYPE"] ?? '';

if (strpos($contentType, 'application/json') !== false) {
    $input = json_decode(file_get_contents("php://input"), true);
    $product_id = $input['product_id'] ?? null;
    $quantity = $input['quantity'] ?? null;
} else {
    $product_id = $_POST['product_id'] ?? null;
    $quantity = $_POST['quantity'] ?? null;
}

if (!$product_id || !$quantity) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Product ID and quantity are required.'
    ]);
    exit;
}

// Check if the product exists and is not deleted
$query = "SELECT category, Variant FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
$result = mysqli_query($conn, $query);

if (mysqli_num_rows($result) > 0) {
    $product = mysqli_fetch_assoc($result);
    $category_id = $product['category'];
    $variant_id = $product['Variant'];

    // Check if the user already has a cart_no
    $cart_no_query = "SELECT cart_no FROM cart WHERE User_id = '$user_id' LIMIT 1";
    $cart_no_result = mysqli_query($conn, $cart_no_query);

    if (mysqli_num_rows($cart_no_result) > 0) {
        $cart_row = mysqli_fetch_assoc($cart_no_result);
        $cart_no = $cart_row['cart_no']; // Use existing cart_no
    } else {
        // Generate a new cart_no
        $max_cart_no_query = "SELECT MAX(CAST(SUBSTRING(cart_no, 5) AS UNSIGNED)) AS max_cart_no FROM cart";
        $max_cart_no_result = mysqli_query($conn, $max_cart_no_query);
        $max_cart_no = 0;

        if (mysqli_num_rows($max_cart_no_result) > 0) {
            $row = mysqli_fetch_assoc($max_cart_no_result);
            $max_cart_no = $row['max_cart_no'];
        }

        $new_cart_no_number = $max_cart_no + 1;
        $cart_no = 'CRT-' . str_pad($new_cart_no_number, 4, '0', STR_PAD_LEFT);
    }

    $created_date = date('Y-m-d H:i:s');
    $insert_query = "INSERT INTO cart (cart_no, User_id, Product_id, Category_id, Variant_id, Quantity, Created_Date, Delete_status)
                     VALUES ('$cart_no', '$user_id', '$product_id', '$category_id', '$variant_id', '$quantity', '$created_date', 0)";

    if (mysqli_query($conn, $insert_query)) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Product added to cart successfully.'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to add product to cart.'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Product not found.'
    ]);
}

mysqli_close($conn);
?>
