<?php
header("Content-Type: application/json");

// Database conn
require 'db.php';

$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['category_id']) && isset($data['product_ids'])) {
    $categoryId = intval($data['category_id']); // Sanitize input
    $productIds = $data['product_ids']; // This is an array of product IDs

    // Iterate through each product ID and update the category
    foreach ($productIds as $productId) {
        $productId = intval($productId); // Sanitize input
        $query = "UPDATE product SET category = $categoryId WHERE product_id = $productId";
        mysqli_query($conn, $query);
    }

    // Send success response
    echo json_encode(["success" => true, "message" => "Products assigned successfully!"]);
} else {
    // Send error response
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Invalid input."]);
}
?>
