<?php
header("Content-Type: application/json");

require 'db.php'; // Ensure this connects correctly to your database

// Read and decode JSON input
$data = json_decode(file_get_contents("php://input"), true);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

if (!$data) {
    echo json_encode(["status" => "error", "message" => "Invalid or missing JSON payload"]);
    exit;
}

// Sanitize input
$customertype = mysqli_real_escape_string($conn, $data['customertype']);
$primarycontact = mysqli_real_escape_string($conn, $data['primarycontact']);
$phonenumber = mysqli_real_escape_string($conn, $data['phonenumber']);
$companyname = mysqli_real_escape_string($conn, $data['companyname']);
$displayname = mysqli_real_escape_string($conn, $data['displayname']);
$name1 = mysqli_real_escape_string($conn, $data['name']);
$email = mysqli_real_escape_string($conn, $data['email']);
$phoneno = mysqli_real_escape_string($conn, $data['phoneno']);
$address = mysqli_real_escape_string($conn, $data['address']);
$city = mysqli_real_escape_string($conn, $data['city']);
$sstate = mysqli_real_escape_string($conn, $data['sstateid']);
$state = mysqli_real_escape_string($conn, $data['state']);
$pincode = mysqli_real_escape_string($conn, $data['pincode']);
$sname = mysqli_real_escape_string($conn, $data['sname']);
$sphonenumber = mysqli_real_escape_string($conn, $data['sphonenumber']);
$saddress = mysqli_real_escape_string($conn, $data['saddress']);
$scity = mysqli_real_escape_string($conn, $data['scity']);
$spincode = mysqli_real_escape_string($conn, $data['spincode']);
$referralcode = mysqli_real_escape_string($conn, $data['referralcode']);
$gstno = mysqli_real_escape_string($conn, $data['gstno']);
$website = mysqli_real_escape_string($conn, $data['website']);
$currency = mysqli_real_escape_string($conn, $data['currency']);
$paymentterms = mysqli_real_escape_string($conn, $data['paymentterms']);
$advance = mysqli_real_escape_string($conn, $data['advance']);
$due = mysqli_real_escape_string($conn, $data['due']);
$type = mysqli_real_escape_string($conn, $data['type']);
$amount = mysqli_real_escape_string($conn, $data['amount']);
$invoice = mysqli_real_escape_string($conn, $data['invoice']);
$description = mysqli_real_escape_string($conn, $data['description']);
$paymenttype = mysqli_real_escape_string($conn, $data['paymenttype']);
$givendate = mysqli_real_escape_string($conn, $data['givendate']);
$receiveddate = mysqli_real_escape_string($conn, $data['receiveddate']);
$currentdate = mysqli_real_escape_string($conn, $data['currentdate']);
$status = mysqli_real_escape_string($conn, $data['status']);
$utmid = mysqli_real_escape_string($conn, $data['utmid']);
$dueadvancestatus = mysqli_real_escape_string($conn, $data['dueadvancestatus']);
$blockcash = mysqli_real_escape_string($conn, $data['blockcash']);
$hasGST = mysqli_real_escape_string($conn, $data['hasGST']);

// Generate UTM ID
$result = mysqli_query($conn, "SELECT utmid FROM customer ORDER BY id DESC LIMIT 1");

if ($result) {
    $row = mysqli_fetch_assoc($result);
    if ($row && isset($row['utmid'])) {
        // Extract numeric part and increment
        $lastUtmId = $row['utmid'];
        $num = intval(substr($lastUtmId, 4)) + 1;
        $utmid = "UTM-" . str_pad($num, 4, '0', STR_PAD_LEFT);
    } else {
        // Default UTM ID if no records exist
        $utmid = "UTM-0001";
    }
} else {
    echo json_encode(["status" => "error", "message" => "Failed to generate UTM ID", "error_detail" => mysqli_error($conn)]);
    exit;
}

// Insert into customer table
$sql_customer = "INSERT INTO customer (
    customertype, primarycontact, phonenumber, companyname, displayname, name1, email, phoneno, 
    address, city, sstate, state, pincode, sphoneno, sname, saddress, scity, spincode, 
    referralcode, gstno, website, currency, paymentterms, advance, due, type, amount, invoice, 
    description, paymenttype, givendate, receiveddate, currentdate, status, utmid, dueadvancestatus, 
    blockcash, hasGST
) VALUES (
    '$customertype', '$primarycontact', '$phonenumber', '$companyname', '$displayname', '$name1', '$email', '$phoneno', 
    '$address', '$city', '$sstate', '$state', '$pincode', '$sphonenumber', '$sname', '$saddress', '$scity', '$spincode', 
    '$referralcode', '$gstno', '$website', '$currency', '$paymentterms', '$advance', '$due', '$type', '$amount', '$invoice', 
    '$description', '$paymenttype', '$givendate', '$receiveddate', '$currentdate', '$status', '$utmid', '$dueadvancestatus', 
    '$blockcash', '$hasGST'
)";

if (mysqli_query($conn, $sql_customer)) {
    $customer_id = mysqli_insert_id($conn); // Retrieve the last inserted ID

    // Insert into customershipping table
    $sql_shipping = "INSERT INTO customershipping (
        customerid, sname, name, sphonenumber, saddress, spincode, scity, sstateid
    ) VALUES (
        '$customer_id', '$sname', '$name1', '$sphonenumber', '$saddress', '$spincode', '$scity', '$sstate'
    )";

    // Check if shipping address and customer address are the same
    $isSameAddress = ($sname === $name1 && $sphonenumber === $phoneno && $saddress === $address && 
                     $scity === $city && $sstate === $state && $spincode === $pincode);

    // Insert into address table
    if ($isSameAddress) {
        // If addresses are the same, insert only once with addresstype = 3
        $insert_query = "INSERT INTO address (customerid, customername, phonenumber, address, city, state, pincode, addresstype) 
                         VALUES ('$customer_id', '$name1', '$phoneno', '$address', '$city', '$state', '$pincode', 3)";
        
        if (!mysqli_query($conn, $insert_query)) {
            echo json_encode(["status" => "error", "message" => "Failed to insert address data", "error_detail" => mysqli_error($conn)]);
            mysqli_close($conn);
            exit;
        }
    } else {
        // If addresses are different, insert both records
        $insert_query1 = "INSERT INTO address (customerid, customername, phonenumber, address, city, state, pincode, addresstype) 
                          VALUES ('$customer_id', '$name1', '$phoneno', '$address', '$city', '$state', '$pincode', 1)";
        $insert_query2 = "INSERT INTO address (customerid, customername, phonenumber, address, city, state, pincode, addresstype) 
                          VALUES ('$customer_id', '$sname', '$sphonenumber', '$saddress', '$scity', '$sstate', '$spincode', 2)";

        if (!mysqli_query($conn, $insert_query1) || !mysqli_query($conn, $insert_query2)) {
            echo json_encode(["status" => "error", "message" => "Failed to insert address data", "error_detail" => mysqli_error($conn)]);
            mysqli_close($conn);
            exit;
        }
    }

    // Execute shipping query
    if (mysqli_query($conn, $sql_shipping)) {
        echo json_encode(["status" => "success", "message" => "Customer and shipping data inserted successfully"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to insert shipping data", "error_detail" => mysqli_error($conn)]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Failed to insert customer data", "error_detail" => mysqli_error($conn)]);
}

mysqli_close($conn);
?>