<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve the banner_id from the URL query parameters
$banner_id = $_GET['banner_id'] ?? null;

// Validate the input
if (!$banner_id) {
    echo json_encode(["status" => "error", "message" => "Banner ID is required"]);
    exit;
}

// Update query to set Delete_status = 1
$deleteQuery = "
    UPDATE banner 
    SET Delete_status = 1 
    WHERE banner_id = '" . mysqli_real_escape_string($conn, $banner_id) . "'
";

// Execute the query
if (mysqli_query($conn, $deleteQuery)) {
    echo json_encode(["status" => "success", "message" => "Banner deleted successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to delete banner"]);
}
?>
