<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is DELETE
if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve Banner_id from the query parameter
$banner_id = $_GET['banner_id'] ?? null; // You can pass the Banner_id as a query parameter

// Check if Banner_id is provided
if (!$banner_id) {
    echo json_encode(["status" => "error", "message" => "Banner ID is required"]);
    exit;
}

// Sanitize Banner_id to prevent SQL injection
$banner_id = mysqli_real_escape_string($conn, $banner_id);

// Query to update Delete_status to 1 (soft delete) based on Banner_id
$query = "UPDATE banner_seo SET Delete_status = 1 WHERE Banner_id = '$banner_id'";

if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "Banner SEO record marked as deleted"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to delete Banner SEO record"]);
}
?>
