<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is DELETE
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve blog_id from the query parameter
$blog_id = $_GET['blog_id'] ?? null;

// Validate the provided blog_id
if (!$blog_id) {
    echo json_encode(["status" => "error", "message" => "Blog ID is required"]);
    exit;
}

// Sanitize blog_id to prevent SQL injection
$blog_id = mysqli_real_escape_string($conn, $blog_id);

// Update query to mark the blog as deleted
$query = "UPDATE blogs SET Delete_status = 1 WHERE blog_id = '$blog_id'";

// Execute the query
if (mysqli_query($conn, $query)) {
    if (mysqli_affected_rows($conn) > 0) {
        echo json_encode(["status" => "success", "message" => "Blog record marked as deleted"]);
    } else {
        echo json_encode(["status" => "error", "message" => "No blog record found with the given ID"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Failed to delete the blog record"]);
}
?>
