<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is DELETE
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve blog_id from the query parameter
$blog_id = $_GET['blog_id'] ?? null; // You can pass the blog_id as a query parameter

// Check if blog_id is provided
if (!$blog_id) {
    echo json_encode(["status" => "error", "message" => "blog ID is required"]);
    exit;
}

// Sanitize blog_id to prevent SQL injection
$blog_id = mysqli_real_escape_string($conn, $blog_id);

// Query to update Delete_status to 1 (soft delete) based on blog_id
$query = "UPDATE blog_seo SET Delete_status = 1 WHERE Blog_id = '$blog_id'";

if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "blog SEO record marked as deleted"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to delete blog SEO record"]);
}
?>
