<?php
include("db.php"); 

session_start();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rawData = file_get_contents('php://input');

    $data = json_decode($rawData, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    if (!isset($data['Product_id'])) {
        echo json_encode(['status' => 'error', 'message' => 'Product_id is required']);
        exit();
    }

    $productId = intval($data['Product_id']);

    $productSql = "UPDATE product SET Delete_status = 1 WHERE Product_id = '$productId'";

    $seoSql = "UPDATE product_seo SET Delete_status = 1 WHERE Product_id = '$productId'";

    $productResult = $conn->query($productSql);
    $seoResult = $conn->query($seoSql);

    if ($productResult && $seoResult) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Product deleted successfully',
            'data' => [
                'Product_id' => $productId,
                'Delete_status' => 1
            ]
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to delete product',
            'product_error' => $conn->error,
            'seo_error' => $conn->error
        ]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
