<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is DELETE
if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve testimonial_id from the query parameter
$testimonial_id = $_GET['testimonial_id'] ?? null; // You can pass the testimonial_id as a query parameter

// Check if testimonial_id is provided
if (!$testimonial_id) {
    echo json_encode(["status" => "error", "message" => "testimonial ID is required"]);
    exit;
}

// Sanitize testimonial_id to prevent SQL injection
$testimonial_id = mysqli_real_escape_string($conn, $testimonial_id);

// Query to update Delete_status to 1 (soft delete) based on testimonial_id
$query = "UPDATE testimonial_seo SET Delete_status = 1 WHERE Testimonial_id = '$testimonial_id'";

if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "testimonial SEO record marked as deleted"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to delete testimonial SEO record"]);
}
?>
