<?php
// Include database connection
include("db.php");

// Start the session
session_start();

// Set content type to JSON
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Check if the session has a valid user_id
    if (isset($_SESSION['user_id']) && !empty($_SESSION['user_id'])) {
        $user_id = $_SESSION['user_id'];

        // Start a transaction
        $conn->begin_transaction();

        try {
            // Update `Delete_status` in user_profile table
            $profileSql = "UPDATE user_profile SET Delete_status = 1 WHERE User_id = ?";
            $stmt1 = $conn->prepare($profileSql);
            $stmt1->bind_param("i", $user_id);

            if (!$stmt1->execute()) {
                throw new Exception("Failed to delete user from user_profile");
            }

            // Update `Delete_status` in user_login table
            $loginSql = "UPDATE user_login SET Delete_status = 1 WHERE Id = ?";
            $stmt2 = $conn->prepare($loginSql);
            $stmt2->bind_param("i", $user_id);

            if (!$stmt2->execute()) {
                throw new Exception("Failed to delete user from user_login");
            }

            // Commit the transaction
            $conn->commit();

            echo json_encode([
                'status' => 'success',
                'message' => 'User deleted successfully'
            ]);
        } catch (Exception $e) {
            // Rollback the transaction in case of error
            $conn->rollback();

            echo json_encode([
                'status' => 'error',
                'message' => $e->getMessage()
            ]);
        }
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'User not logged in or invalid session'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Only POST method is allowed'
    ]);
}

// Close the database connection
$conn->close();
?>
