<?php
include 'db.php'; // Include your database connection file


// Get the estimate_id from the URL (GET method)
$estimate_id = $_GET['estimate_id'] ?? null;

if (!$estimate_id) {
    echo json_encode(["status" => "error", "message" => "Estimate ID is required"]);
    exit;
}

// Validate and fetch the estimate
$estimate_query = "
    SELECT * FROM estimate 
    WHERE estimate_id = '$estimate_id'  AND Delete_status = 0
";
$estimate_result = mysqli_query($conn, $estimate_query);

if (!$estimate_result || mysqli_num_rows($estimate_result) == 0) {
    echo json_encode(["status" => "error", "message" => "Estimate not found or you do not have permission to convert this estimate"]);
    exit;
}

$estimate = mysqli_fetch_assoc($estimate_result);


$estimate_data_query = "
    SELECT * FROM estimate_data 
    WHERE estimate_id = '$estimate_id' AND Delete_status = 0
";
$estimate_data_result = mysqli_query($conn, $estimate_data_query);

if (!$estimate_data_result || mysqli_num_rows($estimate_data_result) == 0) {
    echo json_encode(["status" => "error", "message" => "No products found in this estimate"]);
    exit;
}

$estimate_data = [];
while ($row = mysqli_fetch_assoc($estimate_data_result)) {
    $estimate_data[] = $row;
}

// Generate a unique invoice number
$invoice_no_query = "SELECT MAX(invoice_id) AS max_id FROM invoice";
$invoice_no_result = mysqli_query($conn, $invoice_no_query);
$max_id = mysqli_fetch_assoc($invoice_no_result)['max_id'] ?? 0;
$invoice_no = "INV-" . str_pad($max_id + 1, 4, "0", STR_PAD_LEFT);

// Insert into the invoice table
$created_date = date('Y-m-d H:i:s');

$invoice_query = "
    INSERT INTO invoice (
        Estimate_id,Invoice_no, user_id,displayname,Balance, Created_date, Tax, Tax_percentage, Discount, Discount_percentage, 
        Shipping, Roundoff, Total_saving, Total_price, No_of_items, Total_discount, Grand_total, Action_status,Store_status,
        Created_id, Editor_id, Delete_status
    ) VALUES (
        '$estimate_id','$invoice_no', '{$estimate['user_id']}', '{$estimate['displayname']}','{$estimate['Grand_total']}','$created_date', '{$estimate['Tax']}', '{$estimate['Tax_percentage']}', '{$estimate['Discount']}', 
        '{$estimate['Discount_percentage']}', '{$estimate['Shipping']}', '{$estimate['Roundoff']}', '{$estimate['Total_saving']}', 
        '{$estimate['Total_price']}', '{$estimate['No_of_items']}', '{$estimate['Total_discount']}', '{$estimate['Grand_total']}', 1,0,
        '{$estimate['Created_id']}', '{$estimate['Editor_id']}', 0
    )
";

if (mysqli_query($conn, $invoice_query)) {
    $invoice_id = mysqli_insert_id($conn);


    foreach ($estimate_data as $product) {
        $invoice_data_query = "
            INSERT INTO invoice_data (
                invoice_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
                Tax_percentage, Tax, Product_total, Delete_status
            ) VALUES (
                '$invoice_id', '{$product['Product_id']}', '{$product['qty']}', '{$product['Selling_price']}', '{$product['MRP']}', 
                '{$product['discount']}', '{$product['Discount_percentage']}', '{$product['Tax_percentage']}', '{$product['Tax']}', 
                '{$product['Product_total']}', 0
            )
        ";
        mysqli_query($conn, $invoice_data_query);
    }

 
    $update_estimate_query = "
        UPDATE estimate 
        SET Action_status = 1, Editor_id = '$user_id' 
        WHERE estimate_id = '$estimate_id'
    ";
    mysqli_query($conn, $update_estimate_query);
    $update_product_query = "
    UPDATE product 
    SET qty = qty - '$qty' 
    WHERE Product_id = '$product_id'";
mysqli_query($conn, $update_product_query);
$update_inventory_query = "UPDATE inventory  
    SET Qty = Qty - '$qty',
    date_modified = NOW()
    WHERE Product_id = '$product_id'";

mysqli_query($conn, $update_inventory_query);


    echo json_encode([
        "status" => "success",
        "message" => "Estimate converted to invoice successfully",
        "invoice_id" => $invoice_id
    ]);
    header("Location: https://hapitest.xyz/hapi%20bilzs%20sts/admin/invoices.php");
} else {
    echo json_encode(["status" => "error", "message" => "Failed to create invoice"]);
}
?>
