<?php
// Include database connection
include('db.php');

// Initialize response array
$response = array();

// Check if 'id' parameter is provided in the URL
if (isset($_GET['id'])) {
    // Sanitize and validate 'id'
    $address_id = intval($_GET['id']); // Convert to an integer
    if ($address_id <= 0) { // Validate: Ensure it's a positive number
        $response = array("status" => "error", "message" => "Invalid address ID");
        echo json_encode($response);
        exit;
    }

    // Query to fetch address details
    $addressQuery = "
        SELECT 
        addressid,
            customerid,
            customername,
            phonenumber,
            address,
            city,
            state,
            pincode
        FROM address
        WHERE addressid = $address_id AND Delete_status = 0
    ";

    $addressResult = $conn->query($addressQuery);

    // Fetch a single address (since only one record should be returned)
    if ($row = $addressResult->fetch_assoc()) {
        $response = [
            "status" => "success",
            "data" => [
                'addressid'=> htmlspecialchars($row['addressid']),
                'customerid' => htmlspecialchars($row['customerid']),
                'customername' => htmlspecialchars($row['customername']),
                'phonenumber' => htmlspecialchars($row['phonenumber']),
                'address' => htmlspecialchars($row['address']),
                'city' => htmlspecialchars($row['city']),
                'state' => htmlspecialchars($row['state']),
                'pincode' => htmlspecialchars($row['pincode'])
            ]
        ];
    } else {
        // Address not found
        $response = array("status" => "error", "message" => "Address not found");
    }
} else {
    // 'id' parameter not provided
    $response = array("status" => "error", "message" => "Address ID is required");
}

// Close the database connection
mysqli_close($conn);

// Return the response as JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
