<?php
// Include database connection file
include 'db.php';

// Get HTTP method
$method = $_SERVER['REQUEST_METHOD'];

// Ensure the orderid is set
if ($method == 'GET') {
    if (!isset($_GET['id']) || empty($_GET['id'])) {
        http_response_code(400); // Bad request
        echo json_encode(["error" => "estimate ID is missing."]);
        exit();
    }

    $estimateid = intval($_GET['id']); // Sanitize the order ID

    // Fetch order details
    $orderQuery = "
        SELECT 
            e.estimate_id,
            e.Estimate_no, 
            e.Action_status, 
            e.Created_date, 
            e.Shipping,
            e.Roundoff,
            e.Grand_total, 
            c.displayname,
            c.address,
            c.city,
            c.phoneno,
            c.sname,
            c.sphoneno,
            c.saddress, 
            c.scity,
            c.spincode,
            c.state,
            c.email
        FROM 
            estimate e
        LEFT JOIN 
            customer c ON c.id = e.user_id
        WHERE 
            e.estimate_id = $estimateid;
    ";
    $result = $conn->query($orderQuery);

    $orderDetails = [];
    if ($row = $result->fetch_assoc()) {
        $orderDetails = [
            'estimateno' => htmlspecialchars($row['estimate_id']),
            'estimateid' => htmlspecialchars($row['Estimate_no']),
            'actionstatus' => htmlspecialchars($row['Action_status']),
            'createdate' => htmlspecialchars($row['Created_date']),
            'Shipping' => htmlspecialchars($row['Shipping']),
            'Roundoff'=> htmlspecialchars($row['Roundoff']),
            'grandtotal' => htmlspecialchars($row['Grand_total']),
            'displayname' => htmlspecialchars($row['displayname']),
            'address' => htmlspecialchars($row['address']),
            'city' => htmlspecialchars($row['city']),
            'phoneno' => htmlspecialchars($row['phoneno']),
            'sname' => htmlspecialchars($row['sname']),
            'sphoneno' => htmlspecialchars($row['sphoneno']),
            'saddress' => htmlspecialchars($row['saddress']),
            'scity' => htmlspecialchars($row['scity']),
            'spincode' => htmlspecialchars($row['spincode']),
            'state' => htmlspecialchars($row['state']),
            'email' => htmlspecialchars($row['email']),
            'products' => []
        ];
    }

    // Fetch products related to this order
    $productsQuery = "
    SELECT 
        p.Product_name, 
        p.SKU, 
        p.Product_image,
        ed.qty, 
        ed.MRP, 
        ed.Selling_price, 
        ed.Tax, 
        ed.Tax_percentage, 
        ed.Product_total,
        ed.salepricetax
    FROM 
        estimate_data ed
    LEFT JOIN 
        product p ON p.Product_id = ed.Product_id
    WHERE 
        ed.estimate_id = $estimateid
        AND
        ed.Delete_status = 0;
";

$productResult = $conn->query($productsQuery);

$itemtotal = 0.00;
while ($row = $productResult->fetch_assoc()) {
    $orderDetails['products'][] = [
        'productname' => htmlspecialchars($row['Product_name']),
        'Sku' => htmlspecialchars($row['SKU']),
        'Product_image' => htmlspecialchars($row['Product_image']),
        'qty' => htmlspecialchars($row['qty']),
        'mrp' => htmlspecialchars($row['MRP']),
        'price' => htmlspecialchars($row['Selling_price']),
        'taxvalue' => htmlspecialchars($row['Tax']),
        'taxpercentage' => htmlspecialchars($row['Tax_percentage']),
        'producttotal' => htmlspecialchars($row['Product_total']),
        'salepricetax'=> htmlspecialchars($row['salepricetax'])
    ];

    // Convert values to float for calculation
    $productTotal = floatval($row['Product_total']);
    $taxValue = floatval($row['Tax']);
    $salePriceTax = intval($row['salepricetax']);

    // Add tax if salepricetax is 2
    if ($salePriceTax == 2) {
        $itemtotal += $productTotal + $taxValue;
    } else {
        $itemtotal += $productTotal;
    }
}

$orderDetails['itemtotal'] = htmlspecialchars(number_format($itemtotal, 2));
    // Fetch payments related to this order
   

    $conn->close();

    // Send the result as JSON
    header('Content-Type: application/json');
    echo json_encode($orderDetails);
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(["error" => "Method not allowed. Please use GET."]);
}
?>
