<?php
// Include database connection file
include 'db.php';

// Get HTTP method
$method = $_SERVER['REQUEST_METHOD'];

// Ensure the orderid is set
if ($method == 'GET') {
    if (!isset($_GET['orderid']) || empty($_GET['orderid'])) {
        http_response_code(400); // Bad request
        echo json_encode(["error" => "Order ID is missing."]);
        exit();
    }

    $orderid = intval($_GET['orderid']); // Sanitize the order ID

    // Fetch order details
    $orderQuery = "
        SELECT 
            o.Order_id,
            o.order_no, 
            o.Action_status, 
            o.Created_date, 
            o.Store_status,
            o.Shipping,
            o.Roundoff,
            o.Grand_total, 
            o.Payment_status, 
            i.invoice_no,
            c.displayname,
            c.address,
            c.city,
            c.phoneno,
            c.sname,
            c.sphoneno,
            c.saddress, 
            c.scity,
            c.spincode,
            c.state,
            c.email,
            o.Balance
        FROM 
            orders o
        LEFT JOIN 
            invoice i ON i.order_id = o.Order_id
        LEFT JOIN 
            payment cp ON cp.Order_id = o.Order_id
        LEFT JOIN 
            customer c ON c.id = o.user_id
        WHERE 
            o.Order_id = $orderid;
    ";
    $result = $conn->query($orderQuery);

    $orderDetails = [];
    if ($row = $result->fetch_assoc()) {
        $orderDetails = [
            'orderno' => htmlspecialchars($row['Order_id']),
            'orderid' => htmlspecialchars($row['order_no']),
            'actionstatus' => htmlspecialchars($row['Action_status']),
            'createdate' => htmlspecialchars($row['Created_date']),
            'storestatus' => htmlspecialchars($row['Store_status']),
            'Shipping' => htmlspecialchars($row['Shipping']),
            'Roundoff'=> htmlspecialchars($row['Roundoff']),
            'grandtotal' => htmlspecialchars($row['Grand_total']),
            'paymenttype' => htmlspecialchars($row['Payment_status']),
            'invoiceno' => htmlspecialchars($row['invoice_no']),
            'displayname' => htmlspecialchars($row['displayname']),
            'address' => htmlspecialchars($row['address']),
            'city' => htmlspecialchars($row['city']),
            'phoneno' => htmlspecialchars($row['phoneno']),
            'sname' => htmlspecialchars($row['sname']),
            'sphoneno' => htmlspecialchars($row['sphoneno']),
            'saddress' => htmlspecialchars($row['saddress']),
            'scity' => htmlspecialchars($row['scity']),
            'spincode' => htmlspecialchars($row['spincode']),
            'state' => htmlspecialchars($row['state']),
            'email' => htmlspecialchars($row['email']),
            'products' => [],
            'balance' => htmlspecialchars($row['Balance']),
            'payment' => []
        ];
    }

    // Fetch products related to this order
    $productsQuery = "
    SELECT 
        p.Product_name, 
        p.SKU, 
        p.Product_image,
        od.qty, 
        od.MRP, 
        od.Selling_price, 
        od.Tax, 
        od.Tax_percentage, 
        od.Product_total,
        od.salepricetax
    FROM 
        order_data od
    LEFT JOIN 
        product p ON p.Product_id = od.Product_id
    WHERE 
        od.Order_id = $orderid
        AND
        od.Delete_status = 0;
";

$productResult = $conn->query($productsQuery);

$itemtotal = 0.00;
while ($row = $productResult->fetch_assoc()) {
    $orderDetails['products'][] = [
        'productname' => htmlspecialchars($row['Product_name']),
        'Sku' => htmlspecialchars($row['SKU']),
        'Product_image' => htmlspecialchars($row['Product_image']),
        'qty' => htmlspecialchars($row['qty']),
        'mrp' => htmlspecialchars($row['MRP']),
        'price' => htmlspecialchars($row['Selling_price']),
        'taxvalue' => htmlspecialchars($row['Tax']),
        'taxpercentage' => htmlspecialchars($row['Tax_percentage']),
        'producttotal' => htmlspecialchars($row['Product_total']),
        'salepricetax'=> htmlspecialchars($row['salepricetax'])
    ];

    // Convert values to float for calculation
    $productTotal = floatval($row['Product_total']);
    $taxValue = floatval($row['Tax']);
    $salePriceTax = intval($row['salepricetax']);

    // Add tax if salepricetax is 2
    if ($salePriceTax == 2) {
        $itemtotal += $productTotal + $taxValue;
    } else {
        $itemtotal += $productTotal;
    }
}

$orderDetails['itemtotal'] = htmlspecialchars(number_format($itemtotal, 2));
    // Fetch payments related to this order
    $paymentsQuery = "
        SELECT
            pc.Payment_date,
            pc.Payment_type,
            pc.Amount
        FROM
            payment pc
        WHERE
            pc.Order_id = $orderid;
    ";
    $paymentResult = $conn->query($paymentsQuery);

    while ($row = $paymentResult->fetch_assoc()) {
        $orderDetails['payment'][] = [
            'paymentdate' => htmlspecialchars($row['Payment_date']),
            'paymenttype' => htmlspecialchars($row['Payment_type']),
            'amount' => htmlspecialchars($row['Amount']),
        ];
    }

    $conn->close();

    // Send the result as JSON
    header('Content-Type: application/json');
    echo json_encode($orderDetails);
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(["error" => "Method not allowed. Please use GET."]);
}
?>
