<?php
// Set headers for API response
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database connection
include_once 'db.php';

// Get raw input data
$data = json_decode(file_get_contents("php://input"), true);

// Extract 'barcode' from raw JSON
$barcode = $data['barcode'] ?? null;

if (!$barcode) {
    // Return an error if 'barcode' is missing
    echo json_encode([
        "status" => "error",
        "message" => "Barcode is required"
    ]);
    exit;
}

try {
    // Prepare SQL query to fetch product details using barcode
    $barcode = mysqli_real_escape_string($conn, $barcode);
    $sql = "SELECT 
                Product_id, 
                Product_name, 
                MRP, 
                sale_price_tax, 
                Selling_price, 
                Tax_percentage,
                Discount_percentage 
            FROM 
                product 
            WHERE 
                barcode = '$barcode' 
                AND delete_status = 0";

    $result = mysqli_query($conn, $sql);

    if (!$result) {
        throw new Exception("Query failed: " . mysqli_error($conn));
    }

    // Initialize products array
    $products_arr = [];

    while ($row = mysqli_fetch_assoc($result)) {
        $products_arr[] = [
            "productid" => $row['Product_id'] ?? null,
            "productname" => $row['Product_name'] ?? null,
            "mrp" => $row['MRP'] ?? null,
            "saleprice" => $row['Selling_price'] ?? null,
            "salepricetax" => $row['sale_price_tax'] ?? null,
            "taxpercentage" => $row['Tax_percentage'] ?? null,
            "discountpercentage" => $row["Discount_percentage"] ?? null
        ];
    }

    // Check if product exists
    if (empty($products_arr)) {
        echo json_encode(["status" => "error", "message" => "No product found for this barcode"]);
    } else {
        echo json_encode(["status" => "success", "data" => $products_arr]);
    }

} catch (Exception $e) {
    // Handle any errors
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}

// Close the database connection
mysqli_close($conn);
?>
