<?php
// Include database connection file
include 'db.php';

// Get HTTP method
$method = $_SERVER['REQUEST_METHOD'];

// Ensure the purchaseid is set
if ($method == 'GET') {
    if (!isset($_GET['id']) || empty($_GET['id'])) {
        http_response_code(400); // Bad request
        echo json_encode(["error" => "Purchase ID is missing."]);
        exit();
    }

    $purchaseid = intval($_GET['id']); // Sanitize the purchase ID

    // Fetch purchase details
    $purchaseQuery = "
        SELECT 
            pu.purchase_id,
            pu.purchase_no, 
            pu.Action_status, 
            pu.Created_date, 
            pu.Shipping,
            pu.Roundoff,
            pu.Grand_total, 
            pu.Payment_status, 
            c.displayname,
            c.address,
            c.city,
            c.phoneno,
            c.sname,
            c.sphoneno,
            c.saddress, 
            c.scity,
            c.spincode,
            c.state,
            c.email,
            pu.Balance
        FROM 
            purchase pu
        LEFT JOIN 
            customer c ON c.id = pu.vendor_id
        WHERE 
            pu.purchase_id = $purchaseid
    ";
    
    $result = $conn->query($purchaseQuery);

    if (!$result) {
        http_response_code(500); // Internal Server Error
        echo json_encode(["error" => "Database query failed: " . $conn->error]);
        exit();
    }

    $purchaseDetails = [];
    if ($row = $result->fetch_assoc()) {
        $purchaseDetails = [
            'purchaseno' => htmlspecialchars($row['purchase_id']),
            'purchaseid' => htmlspecialchars($row['purchase_no']),
            'actionstatus' => htmlspecialchars($row['Action_status']),
            'createdate' => htmlspecialchars($row['Created_date']),
            'Shipping' => htmlspecialchars($row['Shipping']),
            'Roundoff' => htmlspecialchars($row['Roundoff']),
            'grandtotal' => htmlspecialchars($row['Grand_total']),
            'paymenttype' => htmlspecialchars($row['Payment_status']),
            'displayname' => htmlspecialchars($row['displayname']),
            'address' => htmlspecialchars($row['address']),
            'city' => htmlspecialchars($row['city']),
            'phoneno' => htmlspecialchars($row['phoneno']),
            'sname' => htmlspecialchars($row['sname']),
            'sphoneno' => htmlspecialchars($row['sphoneno']),
            'saddress' => htmlspecialchars($row['saddress']),
            'scity' => htmlspecialchars($row['scity']),
            'spincode' => htmlspecialchars($row['spincode']),
            'state' => htmlspecialchars($row['state']),
            'email' => htmlspecialchars($row['email']),
            'products' => [],
            'balance' => htmlspecialchars($row['Balance']),
            'payment' => []
        ];
    }

    // Fetch products related to this purchase
    $productsQuery = "
        SELECT 
            p.Product_name, 
            p.SKU, 
            p.Product_image,
            od.qty, 
            od.MRP, 
            od.Selling_price, 
            od.Tax, 
            od.Tax_percentage, 
            od.Product_total,
            od.salepricetax
        FROM 
            purchase_data od
        LEFT JOIN 
            product p ON p.Product_id = od.Product_id
        WHERE 
            od.purchase_id = $purchaseid
            AND od.Delete_status = 0
    ";

    $productResult = $conn->query($productsQuery);

    if (!$productResult) {
        http_response_code(500); // Internal Server Error
        echo json_encode(["error" => "Database query failed: " . $conn->error]);
        exit();
    }

    $itemtotal = 0.00;
    while ($row = $productResult->fetch_assoc()) {
        $purchaseDetails['products'][] = [
            'productname' => htmlspecialchars($row['Product_name']),
            'Sku' => htmlspecialchars($row['SKU']),
            'Product_image' => htmlspecialchars($row['Product_image']),
            'qty' => htmlspecialchars($row['qty']),
            'mrp' => htmlspecialchars($row['MRP']),
            'price' => htmlspecialchars($row['Selling_price']),
            'taxvalue' => htmlspecialchars($row['Tax']),
            'taxpercentage' => htmlspecialchars($row['Tax_percentage']),
            'producttotal' => htmlspecialchars($row['Product_total']),
            'salepricetax' => htmlspecialchars($row['salepricetax'])
        ];

        // Convert values to float for calculation
        $productTotal = floatval($row['Product_total']);
        $taxValue = floatval($row['Tax']);
        $salePriceTax = intval($row['salepricetax']);

        // Add tax if salepricetax is 2
        if ($salePriceTax == 2) {
            $itemtotal += $productTotal + $taxValue;
        } else {
            $itemtotal += $productTotal;
        }
    }

    $purchaseDetails['itemtotal'] = number_format($itemtotal, 2);

    // Fetch payments related to this purchase
    $paymentsQuery = "
        SELECT
            pc.Payment_date,
            pc.Payment_type,
            pc.Amount
        FROM
            payment pc
        WHERE
            pc.purchase_id = $purchaseid
    ";

    $paymentResult = $conn->query($paymentsQuery);

    if (!$paymentResult) {
        http_response_code(500); // Internal Server Error
        echo json_encode(["error" => "Database query failed: " . $conn->error]);
        exit();
    }

    while ($row = $paymentResult->fetch_assoc()) {
        $purchaseDetails['payment'][] = [
            'paymentdate' => htmlspecialchars($row['Payment_date']),
            'paymenttype' => htmlspecialchars($row['Payment_type']),
            'amount' => htmlspecialchars($row['Amount']),
        ];
    }

    $conn->close();

    // Send the result as JSON
    header('Content-Type: application/json');
    echo json_encode($purchaseDetails);
} else {
    http_response_code(405); // Method Not Allowed
    echo json_encode(["error" => "Method not allowed. Please use GET."]);
}
?>