<?php
// db.php for database connection
include('db.php');

// Initialize the response array
$response = array();

// Check if the 'id' parameter is provided in the URL
if (isset($_GET['id'])) {
    // Sanitize and validate the 'id'
    $customer_id = intval($_GET['id']); // Convert to an integer
    if ($customer_id <= 0) { // Validate: Ensure it's a positive number
        $response = array("message" => "Invalid Customer ID");
        echo json_encode($response);
        exit;
    }

    // Query to fetch address details
    $addressQuery = "
        SELECT 
            addressid,
            customerid,
            customername,
            phonenumber,
            address,
            city,
            state,
            pincode
        FROM address
        WHERE customerid = $customer_id AND Delete_status = 0
    ";

    $addressResult = $conn->query($addressQuery);

    $addressDetails = [];
    while ($row = $addressResult->fetch_assoc()) {
        $addressDetails[] = [
            'addressid' => htmlspecialchars($row['addressid']),
            'customerid' => htmlspecialchars($row['customerid']),
            'customername' => htmlspecialchars($row['customername']),
            'phonenumber' => htmlspecialchars($row['phonenumber']),
            'address' => htmlspecialchars($row['address']),
            'city' => htmlspecialchars($row['city']),
            'state' => htmlspecialchars($row['state']),
            'pincode' => htmlspecialchars($row['pincode'])
        ];
    }

    // Check if customer exists
    if (!empty($addressDetails)) {
        $response = [
            "address" => $addressDetails
        ];
    } else {
        // No customer found
        $response = array("message" => "Customer not found");
    }
} else {
    // 'id' parameter not provided
    $response = array("message" => "Customer ID is required");
}

// Close the database connection
mysqli_close($conn);

// Return the response as JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
