<?php
include 'db.php'; // Include your database connection file

// Start the session
session_start();

// Get user ID from the session
$user_id = $_SESSION['user_id'] ?? null;

// Check if user_id is valid
if (!$user_id) {
    echo json_encode(["status" => "error", "message" => "User not logged in"]);
    exit;
}

// Prepare response array
$response = [
    "status" => "error",
    "message" => "No orders found"
];

// Query the `order` table to get all orders for the user
$order_query = "
    SELECT * FROM orders 
    WHERE user_id = '$user_id' AND Delete_status = 0
    ORDER BY Created_date DESC
";

$order_result = mysqli_query($conn, $order_query);

if ($order_result && mysqli_num_rows($order_result) > 0) {
    $orders = [];

    while ($order = mysqli_fetch_assoc($order_result)) {
        $order_id = $order['Order_id'];

        // Fetch order data for this order
        $order_data_query = "
            SELECT * FROM order_data
            WHERE Order_id = '$order_id' AND Delete_status = 0
        ";

        $order_data_result = mysqli_query($conn, $order_data_query);
        $order_data = [];

        if ($order_data_result && mysqli_num_rows($order_data_result) > 0) {
            while ($data = mysqli_fetch_assoc($order_data_result)) {
                $order_data[] = $data;
            }
        }

        // Add order data to the current order
        $order['order_data'] = $order_data;

        // Append to the list of orders
        $orders[] = $order;
    }

    // Return success and the list of orders
    $response['status'] = "success";
    $response['message'] = "orders fetched successfully";
    $response['data'] = $orders;
} else {
    $response['message'] = "No orders found for this user";
}

// Return the response as JSON
echo json_encode($response);
?>
