<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Retrieve optional query parameters
$banner_id = $_GET['banner_id'] ?? null;

// Build the base query
$query = "SELECT * FROM banner WHERE Delete_status = 0 AND active = 1 ";

// Add filters based on query parameters
if ($banner_id) {
    $query .= " AND banner_id = '" . mysqli_real_escape_string($conn, $banner_id) . "'";
}

$query .= " ORDER BY position ASC";
// Execute the query
$result = mysqli_query($conn, $query);

// Check if the query was successful
if (!$result) {
    echo json_encode(["status" => "error", "message" => "Failed to fetch banners"]);
    exit;
}

// Fetch the results as an associative array
$banners = [];
while ($row = mysqli_fetch_assoc($result)) {
    $banners[] = [
        "banner_id" => $row['banner_id'],
        "web_image" => $row['Web_Image'],
        "mobile_banner" => $row['Mobile_banner'],
        "tab_banner" => $row['Tab_banner'],
        "redirect_link" => $row['Redircet_link'],
        "position" => $row['position'],
        "active" => $row['active'],
    ];
}

// Return the results as JSON
echo json_encode([
    "status" => "success",
    "banners" => $banners
]);
?>
