<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve Banner_id from the query parameter
$banner_id = $_GET['banner_id'] ?? null; // You can pass the Banner_id as a query parameter

// Check if Banner_id is provided
if (!$banner_id) {
    echo json_encode(["status" => "error", "message" => "Banner ID is required"]);
    exit;
}

// Sanitize Banner_id to prevent SQL injection
$banner_id = mysqli_real_escape_string($conn, $banner_id);

// Query to fetch SEO data for the given Banner_id
$query = "SELECT * FROM banner_seo WHERE Banner_id = '$banner_id' AND Delete_status = 0"; // Make sure the banner is not marked as deleted

$result = mysqli_query($conn, $query);

// Check if any result was returned
if (mysqli_num_rows($result) > 0) {
    $bannerSeoData = mysqli_fetch_assoc($result);
    echo json_encode(["status" => "success", "data" => $bannerSeoData]);
} else {
    echo json_encode(["status" => "error", "message" => "No SEO data found for the provided Banner ID"]);
}
?>
