<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve query parameters
$blog_id = $_GET['blog_id'] ?? null;

// Sanitize input to prevent SQL injection
if ($blog_id) {
    $blog_id = mysqli_real_escape_string($conn, $blog_id);
}

// Build the SQL query
if ($blog_id) {
    $query = "SELECT * FROM blogs WHERE blog_id = '$blog_id' AND Delete_status = 0";
} else {
    $query = "SELECT * FROM blogs WHERE Delete_status = 0";
}

// Execute the query
$result = mysqli_query($conn, $query);

// Check for query success
if ($result) {
    $blogs = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $blogs[] = [
            "blog_id" => $row['blog_id'],
            "Blog_Title" => $row['Blog_Title'],
            "By_name" => $row['By_name'],
            "description" => $row['description'],
            "Blog_image" => $row['Blog_image'],
            "date" => $row['date'],
            "Category" => $row['Category'],
            "Youtube_link" => $row['Youtube_link'],
            "position" => $row['position'],
            "active" => $row['active'],
            "Delete_status" => $row['Delete_status']
        ];
    }

    echo json_encode([
        "status" => "success",
        "data" => $blogs
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Failed to fetch blog records"
    ]);
}
?>
