<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve blog_id from the query parameter
$blog_id = $_GET['blog_id'] ?? null; // You can pass the blog_id as a query parameter

// Check if blog_id is provided
if (!$blog_id) {
    echo json_encode(["status" => "error", "message" => "blog ID is required"]);
    exit;
}

// Sanitize blog_id to prevent SQL injection
$blog_id = mysqli_real_escape_string($conn, $blog_id);

// Query to fetch SEO data for the given blog_id
$query = "SELECT * FROM blog_seo WHERE Blog_id = '$blog_id' AND Delete_status = 0"; // Make sure the blog is not marked as deleted

$result = mysqli_query($conn, $query);

// Check if any result was returned
if (mysqli_num_rows($result) > 0) {
    $blogSeoData = mysqli_fetch_assoc($result);
    echo json_encode(["status" => "success", "data" => $blogSeoData]);
} else {
    echo json_encode(["status" => "error", "message" => "No SEO data found for the provided blog ID"]);
}
?>
