<?php
// Start the session to get the user_id
session_start();

// Include the database connection
include('db.php'); // Assuming you have a db.php file for DB connection

// Get the user_id from the session
$user_id = $_SESSION['user_id'] ?? null;

// Check if the user is logged in
if (!$user_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.'
    ]);
    exit;
}

// Query to get cart data with product, category, and variant details
$query = "
    SELECT 
        c.Cart_id,
        c.Quantity,
        c.Created_Date,
        p.Product_id,
        p.Product_name,
        p.Product_image,
        p.Price,
        p.MRP,
        p.Selling_price,
        p.qty,
        p.tax,
        p.Tax_percentage,
        cat.category_ID,
        cat.name AS category_name,
        v.Variant_ID,
        v.color AS variant_color,
        v.size AS variant_size
    FROM 
        cart c
    INNER JOIN 
        product p ON c.Product_id = p.Product_id AND p.mode = 1 AND p.Delete_status = 0
    LEFT JOIN 
        categories cat ON c.Category_id = cat.category_ID
    LEFT JOIN 
        product_variants v ON c.Variant_id = v.Variant_ID AND c.Product_id = v.Product_ID
    WHERE 
        c.User_id = '$user_id' AND c.Delete_status = 0
";

// Debugging: print the query to see if it's correct
// echo $query;

// Execute the query
$result = mysqli_query($conn, $query);

// Check if the query was successful
if ($result) {
    // Fetch all results into an associative array
    $cart_data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $cart_data[] = [
            'cart_id' => $row['Cart_id'],
            'product_name' => $row['Product_name'],
            'product_image' => $row['Product_image'],
            'price' => $row['Price'],
            'mrp' => $row['MRP'],
            'selling_price' => $row['Selling_price'],
            'qty' => $row['qty'],
            'tax' => $row['tax'],
            'tax_percentage' => $row['Tax_percentage'],
            'category_name' => $row['category_name'],
            'variant_color' => $row['variant_color'],
            'variant_size' => $row['variant_size'],
            'quantity' => $row['Quantity'],
            'created_date' => $row['Created_Date']
        ];
    }

    // Check if cart data is empty
    if (!empty($cart_data)) {
        echo json_encode([
            'status' => 'success',
            'data' => $cart_data
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'No products found in the cart.'
        ]);
    }
} else {
    // Handle query error
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch cart data.',
        'error' => mysqli_error($conn)
    ]);
}

// Close the database connection
mysqli_close($conn);
?>
