<?php
include 'db.php'; 

$estimate_id = $_GET['estimate_id'] ?? null;

if (!$estimate_id) {
    echo json_encode(["status" => "error", "message" => "Estimate ID is required"]);
    exit;
}

// Prepare response array
$response = [
    "status" => "error",
    "message" => "No estimate found for this ID"
];

// Query the `estimate` table to get estimate data for the user and specific estimate_id
$estimate_query = "
    SELECT e.*, 
           c.displayname, 
           c.phoneno, 
           c.address, 
           c.city, 
           c.state, 
           c.pincode
    FROM estimate e
    LEFT JOIN customer c ON e.user_id = c.id
    WHERE e.Delete_status = 0 AND e.estimate_id = '$estimate_id'
    ORDER BY e.Created_date DESC
";

$estimate_result = mysqli_query($conn, $estimate_query);

if ($estimate_result && mysqli_num_rows($estimate_result) > 0) {
    $estimate = mysqli_fetch_assoc($estimate_result);
    
    // Fetch estimate data for the particular estimate
    $estimate_data_query = "
        SELECT * FROM estimate_data
        WHERE estimate_id = '$estimate_id' AND Delete_status = 0
    ";

    $estimate_data_result = mysqli_query($conn, $estimate_data_query);

    $estimate_data = [];
    if ($estimate_data_result && mysqli_num_rows($estimate_data_result) > 0) {
        while ($data = mysqli_fetch_assoc($estimate_data_result)) {
            $estimate_data[] = $data;
        }
    }

    // Add estimate data to the estimate
    $estimate['estimate_data'] = $estimate_data;

    // Return success and the estimate data
    $response['status'] = "success";
    $response['message'] = "Estimate fetched successfully";
    $response['data'] = $estimate;
} else {
    $response['message'] = "Estimate not found for this user";
}

// Return the response as JSON
echo json_encode($response);
?>
